/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.jdbc;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.jdbc.JDBCAuthorization.class)
public class JDBCAuthorization extends io.vertx.reactivex.ext.auth.authorization.AuthorizationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCAuthorization that = (JDBCAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCAuthorization((io.vertx.ext.auth.jdbc.JDBCAuthorization) obj),
    JDBCAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCAuthorization delegate;
  
  public JDBCAuthorization(io.vertx.ext.auth.jdbc.JDBCAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCAuthorization(Object delegate) {
    super((io.vertx.ext.auth.jdbc.JDBCAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.jdbc.JDBCAuthorization)delegate;
  }

  public io.vertx.ext.auth.jdbc.JDBCAuthorization getDelegate() {
    return delegate;
  }

  /**
   * Create a JDBC authorization provider implementation
   * @param providerId the provider id
   * @param client the JDBC client instance
   * @param options the {@link io.vertx.ext.auth.jdbc.JDBCAuthorizationOptions}
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.auth.jdbc.JDBCAuthorization create(java.lang.String providerId, io.vertx.reactivex.ext.jdbc.JDBCClient client, io.vertx.ext.auth.jdbc.JDBCAuthorizationOptions options) { 
    io.vertx.reactivex.ext.auth.jdbc.JDBCAuthorization ret = io.vertx.reactivex.ext.auth.jdbc.JDBCAuthorization.newInstance((io.vertx.ext.auth.jdbc.JDBCAuthorization)io.vertx.ext.auth.jdbc.JDBCAuthorization.create(providerId, client.getDelegate(), options));
    return ret;
  }

  public static JDBCAuthorization newInstance(io.vertx.ext.auth.jdbc.JDBCAuthorization arg) {
    return arg != null ? new JDBCAuthorization(arg) : null;
  }

}
