/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.eventbus;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x event-bus is a light-weight distributed messaging system which allows different parts of your application,
 * or different applications and services to communicate with each in a loosely coupled way.
 * <p>
 * An event-bus supports publish-subscribe messaging, point-to-point messaging and request-response messaging.
 * <p>
 * Message delivery is best-effort and messages can be lost if failure of all or part of the event bus occurs.
 * <p>
 * Please refer to the documentation for more information on the event bus.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.EventBus original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.eventbus.EventBus.class)
public class EventBus implements io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBus that = (EventBus) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<EventBus> __TYPE_ARG = new TypeArg<>(    obj -> new EventBus((io.vertx.core.eventbus.EventBus) obj),
    EventBus::getDelegate
  );

  private final io.vertx.core.eventbus.EventBus delegate;
  
  public EventBus(io.vertx.core.eventbus.EventBus delegate) {
    this.delegate = delegate;
  }

  public EventBus(Object delegate) {
    this.delegate = (io.vertx.core.eventbus.EventBus)delegate;
  }

  public io.vertx.core.eventbus.EventBus getDelegate() {
    return delegate;
  }


  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Sends a message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus send(java.lang.String address, java.lang.Object message) { 
    delegate.send(address, message);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#send} but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus send(java.lang.String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.send(address, message, options);
    return this;
  }

  /**
   * Sends a message and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(java.lang.String address, java.lang.Object message, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, new io.vertx.lang.rx.DelegatingHandler<>(replyHandler, ar -> ar.map(event -> io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, TypeArg.unknown()))));
    return this;
  }

  /**
   * Sends a message and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(java.lang.String address, java.lang.Object message) {
    return 
request(address, message, ar -> { });
  }

  /**
   * Sends a message and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.reactivex.Single<io.vertx.reactivex.core.eventbus.Message<T>> rxRequest(java.lang.String address, java.lang.Object message) { 
    return AsyncResultSingle.toSingle($handler -> {
      request(address, message, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#request} but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(java.lang.String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, options, new io.vertx.lang.rx.DelegatingHandler<>(replyHandler, ar -> ar.map(event -> io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, TypeArg.unknown()))));
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#request} but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(java.lang.String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) {
    return 
request(address, message, options, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#request} but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.reactivex.Single<io.vertx.reactivex.core.eventbus.Message<T>> rxRequest(java.lang.String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      request(address, message, options, $handler);
    });
  }

  /**
   * Publish a message.<p>
   * The message will be delivered to all handlers registered to the address.
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus publish(java.lang.String address, java.lang.Object message) { 
    delegate.publish(address, message);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#publish} but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @param options the delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus publish(java.lang.String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.publish(address, message, options);
    return this;
  }

  /**
   * Create a message consumer against the specified address.
   * <p>
   * The returned consumer is not yet registered
   * at the address, registration will be effective when {@link io.vertx.reactivex.core.eventbus.MessageConsumer#handler}
   * is called.
   * @param address the address that it will register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> consumer(java.lang.String address) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.consumer(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a consumer and register it against the specified address.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> consumer(java.lang.String address, io.vertx.core.Handler<io.vertx.reactivex.core.eventbus.Message<T>> handler) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.consumer(address, new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, TypeArg.unknown()))), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#consumer} but the address won't be propagated across the cluster.
   * @param address the address to register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> localConsumer(java.lang.String address) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.localConsumer(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#consumer} but the address won't be propagated across the cluster.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> localConsumer(java.lang.String address, io.vertx.core.Handler<io.vertx.reactivex.core.eventbus.Message<T>> handler) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.localConsumer(address, new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, TypeArg.unknown()))), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a message sender against the specified address.
   * <p>
   * The returned sender will invoke the {@link io.vertx.reactivex.core.eventbus.EventBus#send}
   * method when the stream {@link io.vertx.reactivex.core.streams.WriteStream#write} method is called with the sender
   * address and the provided data.
   * @param address the address to send it to
   * @return The sender
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> sender(java.lang.String address) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.sender(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#sender} but specifying delivery options that will be used for configuring the delivery of
   * the message.
   * @param address the address to send it to
   * @param options the delivery options
   * @return The sender
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> sender(java.lang.String address, io.vertx.core.eventbus.DeliveryOptions options) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.sender(address, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a message publisher against the specified address.
   * <p>
   * The returned publisher will invoke the {@link io.vertx.reactivex.core.eventbus.EventBus#publish}
   * method when the stream {@link io.vertx.reactivex.core.streams.WriteStream#write} method is called with the publisher
   * address and the provided data.
   * @param address The address to publish it to
   * @return The publisher
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> publisher(java.lang.String address) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.publisher(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#publisher} but specifying delivery options that will be used for configuring the delivery of
   * the message.
   * @param address the address to publish it to
   * @param options the delivery options
   * @return The publisher
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> publisher(java.lang.String address, io.vertx.core.eventbus.DeliveryOptions options) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.publisher(address, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Set selector to be invoked when the bus has not found any codec for a {@link io.vertx.reactivex.core.eventbus.Message} body.
   * <p>
   * The selector must return the name of a codec which has been registered with either {@link io.vertx.reactivex.core.eventbus.EventBus#registerCodec} or {@link io.vertx.reactivex.core.eventbus.EventBus#registerDefaultCodec}.
   * @param selector the codec selector
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus codecSelector(java.util.function.Function<java.lang.Object,java.lang.String> selector) { 
    delegate.codecSelector(selector);
    return this;
  }

  /**
   * Add an interceptor that will be called whenever a message is sent from Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus addOutboundInterceptor(io.vertx.core.Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addOutboundInterceptor(new io.vertx.lang.rx.DelegatingHandler<>(interceptor, event -> io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown())));
    return this;
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.reactivex.core.eventbus.EventBus#addOutboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus removeOutboundInterceptor(io.vertx.core.Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeOutboundInterceptor(new io.vertx.lang.rx.DelegatingHandler<>(interceptor, event -> io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown())));
    return this;
  }

  /**
   * Add an interceptor that will be called whenever a message is received by Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus addInboundInterceptor(io.vertx.core.Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addInboundInterceptor(new io.vertx.lang.rx.DelegatingHandler<>(interceptor, event -> io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown())));
    return this;
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.reactivex.core.eventbus.EventBus#addInboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus removeInboundInterceptor(io.vertx.core.Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeInboundInterceptor(new io.vertx.lang.rx.DelegatingHandler<>(interceptor, event -> io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown())));
    return this;
  }

  /**
   * Register a predicate to invoke when verifying if an object is forbidden to be encoded/decoded as {@link io.vertx.core.shareddata.ClusterSerializable}.
   * <p>
   * This is only used when Vert.x is clustered.
   * @param classNamePredicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus clusterSerializableChecker(java.util.function.Function<java.lang.String,java.lang.Boolean> classNamePredicate) { 
    delegate.clusterSerializableChecker(classNamePredicate);
    return this;
  }

  /**
   * Register a predicate to invoke when verifying if an object is allowed to be encoded/decoded as {@link java.io.Serializable}.
   * <p>
   * This is only used when Vert.x is clustered.
   * @param classNamePredicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus serializableChecker(java.util.function.Function<java.lang.String,java.lang.Boolean> classNamePredicate) { 
    delegate.serializableChecker(classNamePredicate);
    return this;
  }

  /**
   * Register a message codec.
   * <p>
   * You can register a message codec if you want to send any non standard message across the event bus.
   * E.g. you might want to send POJOs directly across the event bus.
   * <p>
   * To use a message codec for a send, you should specify it in the delivery options.
   * @param codec the message codec to register
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus registerCodec(io.vertx.core.eventbus.MessageCodec codec) { 
    delegate.registerCodec(codec);
    return this;
  }

  /**
   * Unregister a message codec.
   * @param name the name of the codec
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus unregisterCodec(java.lang.String name) { 
    delegate.unregisterCodec(name);
    return this;
  }

  public static EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
    return arg != null ? new EventBus(arg) : null;
  }

}
