/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A timeout stream is triggered by a timer, the {@link io.vertx.core.Handler} will be call when the timer is fired,
 * it can be once or several times depending on the nature of the timer related to this stream. The
 *  will be called after the timer handler has been called.
 * <p>
 * Pausing the timer inhibits the timer shots until the stream is resumed. Setting a null handler callback cancels
 * the timer.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.TimeoutStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.TimeoutStream.class)
public class TimeoutStream implements io.vertx.reactivex.core.streams.ReadStream<java.lang.Long> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeoutStream that = (TimeoutStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TimeoutStream> __TYPE_ARG = new TypeArg<>(    obj -> new TimeoutStream((io.vertx.core.TimeoutStream) obj),
    TimeoutStream::getDelegate
  );

  private final io.vertx.core.TimeoutStream delegate;
  
  public TimeoutStream(io.vertx.core.TimeoutStream delegate) {
    this.delegate = delegate;
  }

  public TimeoutStream(Object delegate) {
    this.delegate = (io.vertx.core.TimeoutStream)delegate;
  }

  public io.vertx.core.TimeoutStream getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<java.lang.Long> observable;
  private io.reactivex.Flowable<java.lang.Long> flowable;

  public synchronized io.reactivex.Observable<java.lang.Long> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<java.lang.Long> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  @Deprecated()
  public io.vertx.reactivex.core.streams.Pipe<java.lang.Long> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<java.lang.Long> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  @Deprecated()
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<java.lang.Long> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  @Deprecated()
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<java.lang.Long> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  @Deprecated()
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<java.lang.Long> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      pipeTo(dst, $handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.core.TimeoutStream exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.core.TimeoutStream handler(io.vertx.core.Handler<java.lang.Long> handler) { 
    delegate.handler(handler);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.core.TimeoutStream pause() { 
    delegate.pause();
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.core.TimeoutStream resume() { 
    delegate.resume();
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.core.TimeoutStream fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.core.TimeoutStream endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Cancels the timeout. Note this has the same effect as calling {@link io.vertx.reactivex.core.TimeoutStream#handler} with a null
   * argument.
   */
  @Deprecated()
  public void cancel() { 
    delegate.cancel();
  }

  public static TimeoutStream newInstance(io.vertx.core.TimeoutStream arg) {
    return arg != null ? new TimeoutStream(arg) : null;
  }

}
