/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.ArrayQueue;
import io.vertx.redis.client.impl.ParserHandler;
import io.vertx.redis.client.impl.RedisConnectionInternal;
import io.vertx.redis.client.impl.RequestImpl;
import io.vertx.redis.client.impl.types.ErrorType;
import io.vertx.redis.client.impl.types.Multi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RedisStandaloneConnection
implements RedisConnectionInternal,
ParserHandler {
    private static final String BASE_ADDRESS = "io.vertx.redis";
    private static final Logger LOG = LoggerFactory.getLogger(RedisStandaloneConnection.class);
    private static final ErrorType CONNECTION_CLOSED = ErrorType.create("CONNECTION_CLOSED");
    private final PoolConnector.Listener listener;
    private final VertxInternal vertx;
    private final ContextInternal context;
    private final EventBus eventBus;
    private final NetSocket netSocket;
    private final long expiresAt;
    private final ArrayQueue waiting;
    private Handler<Throwable> onException;
    private Handler<Void> onEnd;
    private Handler<Response> onMessage;
    private Runnable onEvict;
    private boolean isValid;
    private boolean tainted;

    public RedisStandaloneConnection(Vertx vertx, ContextInternal context, PoolConnector.Listener connectionListener, NetSocket netSocket, RedisOptions options) {
        this.vertx = (VertxInternal)vertx;
        this.context = context;
        this.listener = connectionListener;
        this.eventBus = vertx.eventBus();
        this.netSocket = netSocket;
        this.waiting = new ArrayQueue(options.getMaxWaitingHandlers());
        this.expiresAt = options.getPoolRecycleTimeout() == -1 ? -1L : System.currentTimeMillis() + (long)options.getPoolRecycleTimeout();
    }

    void setValid() {
        this.isValid = true;
        this.tainted = false;
    }

    @Override
    public synchronized void forceClose() {
        this.evict();
        this.netSocket.close();
    }

    @Override
    public boolean isValid() {
        return this.isValid && (this.expiresAt <= 0L || System.currentTimeMillis() < this.expiresAt);
    }

    @Override
    public Future<Void> close() {
        if (this.listener == null) {
            return this.netSocket.close();
        }
        return Future.succeededFuture();
    }

    @Override
    public boolean pendingQueueFull() {
        return this.waiting.isFull();
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.onException = handler;
        return this;
    }

    @Override
    public RedisConnection endHandler(Handler<Void> handler) {
        this.onEnd = handler;
        return this;
    }

    RedisConnection evictHandler(Runnable handler) {
        this.onEvict = handler;
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        this.onMessage = handler;
        return this;
    }

    @Override
    public RedisConnection pause() {
        this.netSocket.pause();
        return this;
    }

    @Override
    public RedisConnection resume() {
        this.netSocket.resume();
        return this;
    }

    @Override
    public RedisConnection fetch(long size) {
        return this;
    }

    private void taintCheck(Command cmd) {
        if (this.listener != null && !this.tainted && (cmd.isPubSub() || Command.SELECT.equals(cmd) || Command.AUTH.equals(cmd))) {
            this.tainted = true;
        }
    }

    @Override
    public Future<Response> send(Request request) {
        PromiseInternal promise = this.vertx.promise();
        boolean voidCmd = request.command().isVoid();
        Buffer message = ((RequestImpl)request).encode();
        this.context.execute(arg_0 -> this.lambda$send$1(voidCmd, (Promise)promise, message, request, arg_0));
        return promise.future();
    }

    @Override
    public Future<List<Response>> batch(List<Request> commands) {
        PromiseInternal promise = this.vertx.promise();
        if (commands.isEmpty()) {
            LOG.debug((Object)"Empty batch");
            promise.complete(Collections.emptyList());
        } else {
            ArrayList<PromiseInternal> callbacks = new ArrayList<PromiseInternal>(commands.size());
            ArrayList replies = new ArrayList(commands.size());
            AtomicInteger count = new AtomicInteger(commands.size());
            AtomicBoolean failed = new AtomicBoolean(false);
            Buffer messages = Buffer.buffer();
            int i = 0;
            while (i < commands.size()) {
                int index = i++;
                RequestImpl req = (RequestImpl)commands.get(index);
                req.encode(messages);
                this.taintCheck(req.command());
                callbacks.add(index, this.vertx.promise(arg_0 -> RedisStandaloneConnection.lambda$batch$2(failed, (Promise)promise, replies, index, count, arg_0)));
            }
            this.context.execute(arg_0 -> this.lambda$batch$4(callbacks, (Promise)promise, messages, arg_0));
        }
        return promise.future();
    }

    @Override
    public void handle(Response reply) {
        if (reply != null && reply.type() == ResponseType.PUSH || this.waiting.isEmpty()) {
            if (this.onMessage != null) {
                this.context.execute((Object)reply, this.onMessage);
            } else {
                if (reply instanceof Multi) {
                    if (reply.size() == 3 && "message".equals(reply.get(0).toString())) {
                        this.eventBus.send("io.vertx.redis." + reply.get(1).toString(), (Object)new JsonObject().put("status", (Object)"OK").put("value", (Object)new JsonObject().put("channel", (Object)reply.get(1).toString()).put("message", (Object)reply.get(2).toString())));
                        return;
                    }
                    if (reply.size() == 4 && "pmessage".equals(reply.get(0).toString())) {
                        this.eventBus.send("io.vertx.redis." + reply.get(1).toString(), (Object)new JsonObject().put("status", (Object)"OK").put("value", (Object)new JsonObject().put("pattern", (Object)reply.get(1).toString()).put("channel", (Object)reply.get(2).toString()).put("message", (Object)reply.get(3).toString())));
                        return;
                    }
                }
                LOG.warn((Object)("No handler waiting for message: " + reply));
            }
            return;
        }
        this.context.execute(v -> {
            Promise req = (Promise)this.waiting.poll();
            if (req != null) {
                if (reply == null) {
                    try {
                        req.complete();
                    }
                    catch (RuntimeException e) {
                        this.fail(e);
                    }
                    return;
                }
                if (reply.type() == ResponseType.ERROR) {
                    try {
                        req.fail((Throwable)((ErrorType)reply));
                    }
                    catch (RuntimeException e) {
                        this.fail(e);
                    }
                    return;
                }
                try {
                    req.complete((Object)reply);
                }
                catch (RuntimeException e) {
                    this.fail(e);
                }
            } else {
                LOG.error((Object)("No handler waiting for message: " + reply));
            }
        });
    }

    public void end(Void v) {
        this.evict();
        this.cleanupQueue(CONNECTION_CLOSED).onComplete(v1 -> {
            if (this.onEnd != null) {
                this.context.execute((Object)v, this.onEnd);
            }
        });
    }

    @Override
    public synchronized void fail(Throwable t) {
        this.evict();
        if (this.onException != null) {
            this.context.execute((Object)t, this.onException);
        }
    }

    @Override
    public synchronized void fatal(Throwable t) {
        this.evict();
        this.cleanupQueue(t).onComplete(v -> {
            if (this.onException != null) {
                this.context.execute((Object)t, this.onException);
            }
        });
    }

    @Override
    public synchronized boolean reset() {
        if (this.tainted) {
            this.evict();
        }
        return !this.tainted;
    }

    private void evict() {
        this.isValid = false;
        if (this.listener != null) {
            this.listener.onRemove();
        }
        if (this.onEvict != null) {
            this.onEvict.run();
        }
    }

    private Future<Void> cleanupQueue(Throwable t) {
        PromiseInternal cleanup = this.vertx.promise();
        this.context.execute(arg_0 -> this.lambda$cleanupQueue$8(t, (Promise)cleanup, arg_0));
        return cleanup.future();
    }

    private /* synthetic */ void lambda$cleanupQueue$8(Throwable t, Promise cleanup, Void v) {
        Promise req;
        while ((req = (Promise)this.waiting.poll()) != null) {
            if (t == null) continue;
            try {
                req.fail(t);
            }
            catch (RuntimeException e) {
                LOG.warn((Object)"Exception during cleanup", (Throwable)e);
            }
        }
        cleanup.complete();
    }

    private /* synthetic */ void lambda$batch$4(List callbacks, Promise promise, Buffer messages, Void v) {
        if (this.waiting.freeSlots() < callbacks.size()) {
            promise.fail("Redis waiting Queue is full");
            return;
        }
        for (Promise callback : callbacks) {
            this.waiting.offer(callback);
        }
        this.netSocket.write(messages, write -> {
            if (write.failed()) {
                this.fatal(write.cause());
            }
        });
    }

    private static /* synthetic */ void lambda$batch$2(AtomicBoolean failed, Promise promise, List replies, int index, AtomicInteger count, AsyncResult command) {
        if (!failed.get() && command.failed()) {
            failed.set(true);
            promise.fail(command.cause());
            return;
        }
        replies.add(index, command.result());
        if (count.decrementAndGet() == 0) {
            promise.complete((Object)replies);
        }
    }

    private /* synthetic */ void lambda$send$1(boolean voidCmd, Promise promise, Buffer message, Request request, Void v) {
        if (!voidCmd) {
            if (this.waiting.isFull()) {
                promise.fail("Redis waiting Queue is full");
                return;
            }
            this.waiting.offer(promise);
        }
        this.netSocket.write(message, write -> {
            if (write.failed()) {
                this.fatal(write.cause());
            } else {
                this.taintCheck(request.command());
                if (voidCmd) {
                    promise.complete();
                }
            }
        });
    }
}

