/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.List;

public class RedisSentinelConnection
implements RedisConnection {
    private final RedisConnection connection;
    private final RedisConnection sentinel;

    public RedisSentinelConnection(RedisConnection connection, RedisConnection sentinel) {
        this.connection = connection;
        this.sentinel = sentinel;
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.connection.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        this.connection.handler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection pause() {
        this.connection.pause();
        return this;
    }

    @Override
    public RedisConnection resume() {
        this.connection.resume();
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        this.connection.fetch(amount);
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> endHandler) {
        this.connection.endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public Future<@Nullable Response> send(Request command) {
        return this.connection.send(command);
    }

    @Override
    public Future<List<@Nullable Response>> batch(List<Request> commands) {
        return this.connection.batch(commands);
    }

    @Override
    public Future<Void> close() {
        Promise promise = Promise.promise();
        this.sentinel.close().onSuccess(done -> this.connection.close((Handler<AsyncResult<Void>>)promise)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    @Override
    public boolean pendingQueueFull() {
        return this.connection.pendingQueueFull();
    }
}

