/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.RedisReplicationConnection;
import io.vertx.redis.client.impl.RedisURI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RedisReplicationClient
extends BaseRedisClient
implements Redis {
    private static final Logger LOG = LoggerFactory.getLogger(RedisReplicationClient.class);
    private final RedisOptions options;

    public static void addMasterOnlyCommand(Command command) {
        RedisReplicationConnection.addMasterOnlyCommand(command);
    }

    public RedisReplicationClient(Vertx vertx, RedisOptions options) {
        super(vertx, options);
        this.options = options;
        if (options.getMaxPoolWaiting() < options.getMaxPoolSize()) {
            throw new IllegalStateException("Invalid options: maxPoolWaiting < maxPoolSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        LinkedList<String> endpoints = new LinkedList<String>(this.options.getEndpoints());
        this.connect(endpoints, 0, (Handler<AsyncResult<RedisConnection>>)promise);
        return promise.future();
    }

    private void connect(List<String> endpoints, int index, Handler<AsyncResult<RedisConnection>> onConnect) {
        if (index >= endpoints.size()) {
            onConnect.handle((Object)Future.failedFuture((String)"Cannot connect to any of the provided endpoints"));
            return;
        }
        this.connectionManager.getConnection(endpoints.get(index), null).onFailure(err -> this.connect(endpoints, index + 1, onConnect)).onSuccess(conn -> this.getNodes((RedisConnection)conn, endpoints, index, (Handler<AsyncResult<List<Node>>>)((Handler)getNodes -> {
            if (getNodes.failed()) {
                conn.close();
                this.connect(endpoints, index + 1, onConnect);
                return;
            }
            List nodes = (List)getNodes.result();
            AtomicInteger counter = new AtomicInteger();
            ArrayList<RedisConnection> connections = new ArrayList<RedisConnection>();
            int totalUniqueEndpoints = nodes.size();
            if (this.options.getMaxPoolSize() < totalUniqueEndpoints) {
                onConnect.handle((Object)Future.failedFuture((String)("RedisOptions maxPoolSize < Cluster size(" + totalUniqueEndpoints + "): The pool is not able to hold all required connections!")));
                return;
            }
            for (Node node : nodes) {
                if (!node.online) {
                    LOG.info((Object)("Skipping offline node: " + node.ip));
                    if (counter.incrementAndGet() != nodes.size()) continue;
                    onConnect.handle((Object)Future.succeededFuture((Object)new RedisReplicationConnection((Vertx)this.vertx, this.options, (RedisConnection)conn, (List<RedisConnection>)connections)));
                    continue;
                }
                this.connectionManager.getConnection(node.endpoint(), RedisReplicas.NEVER != this.options.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> {
                    LOG.warn((Object)("Skipping failed node: " + node.ip), err);
                    if (counter.incrementAndGet() == nodes.size()) {
                        onConnect.handle((Object)Future.succeededFuture((Object)new RedisReplicationConnection((Vertx)this.vertx, this.options, (RedisConnection)conn, (List<RedisConnection>)connections)));
                    }
                }).onSuccess(cconn -> {
                    List list = connections;
                    synchronized (list) {
                        connections.add((RedisConnection)cconn);
                    }
                    if (counter.incrementAndGet() == nodes.size()) {
                        onConnect.handle((Object)Future.succeededFuture((Object)new RedisReplicationConnection((Vertx)this.vertx, this.options, (RedisConnection)conn, (List<RedisConnection>)connections)));
                    }
                });
            }
        })));
    }

    private void getNodes(RedisConnection conn, List<String> endpoints, int index, Handler<AsyncResult<List<Node>>> onGetSlots) {
        conn.send(Request.cmd(Command.INFO).arg("REPLICATION"), (Handler<AsyncResult<Response>>)((Handler)send -> {
            if (send.failed()) {
                onGetSlots.handle((Object)Future.failedFuture((Throwable)send.cause()));
                return;
            }
            Map<String, String> reply = this.parseInfo((Response)send.result());
            if (reply.size() == 0) {
                onGetSlots.handle((Object)Future.failedFuture((String)"INFO REPLICATION No config available in the node."));
                return;
            }
            RedisURI uri = new RedisURI((String)endpoints.get(index));
            switch (reply.get("role")) {
                case "master": {
                    try {
                        ArrayList<Node> nodes = new ArrayList<Node>();
                        int totalNodes = Integer.parseInt(reply.get("connected_slaves"));
                        for (int i = 0; i < totalNodes; ++i) {
                            nodes.add(new Node(uri, reply.get("slave" + i)));
                        }
                        onGetSlots.handle((Object)Future.succeededFuture(nodes));
                        return;
                    }
                    catch (RuntimeException e) {
                        onGetSlots.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                }
                case "slave": {
                    try {
                        String masterHost = reply.get("master_host");
                        String masterPort = reply.get("master_port");
                        endpoints.add(index + 1, uri.protocol() + "://" + uri.userinfo() + masterHost + ":" + masterPort);
                        onGetSlots.handle((Object)Future.failedFuture((String)"Connected to replica, retrying with master"));
                        return;
                    }
                    catch (RuntimeException e) {
                        onGetSlots.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                }
            }
            onGetSlots.handle((Object)Future.failedFuture((String)("INFO REPLICATION invalid role: " + reply.get("role"))));
        }));
    }

    private Map<String, String> parseInfo(Response response) {
        if (response == null) {
            return Collections.emptyMap();
        }
        String text = response.toString(StandardCharsets.ISO_8859_1);
        if (text == null || text.length() == 0) {
            return Collections.emptyMap();
        }
        String[] lines = text.split("\r\n");
        HashMap<String, String> info = new HashMap<String, String>();
        for (String line : lines) {
            int idx = line.indexOf(58);
            if (idx != -1) {
                info.put(line.substring(0, idx), line.substring(idx + 1));
                continue;
            }
            info.put(line, null);
        }
        return info;
    }

    static {
        RedisReplicationClient.addMasterOnlyCommand(Command.WAIT);
    }

    static class Node {
        private final RedisURI parent;
        final String ip;
        final int port;
        final boolean online;

        Node(RedisURI parent, String raw) {
            this.parent = parent;
            String[] parts = raw.split(",");
            String _ip = null;
            String _port = "6379";
            String _state = null;
            block10: for (String part : parts) {
                String value;
                String key;
                int idx = part.indexOf(61);
                if (idx != -1) {
                    key = part.substring(0, idx);
                    value = part.substring(idx + 1);
                } else {
                    key = part;
                    value = null;
                }
                switch (key) {
                    case "ip": {
                        _ip = value;
                        continue block10;
                    }
                    case "port": {
                        _port = value;
                        continue block10;
                    }
                    case "state": {
                        _state = value;
                    }
                }
            }
            this.ip = _ip;
            this.port = Integer.parseInt(_port);
            this.online = "online".equals(_state);
        }

        String endpoint() {
            return this.parent.protocol() + "://" + this.parent.userinfo() + this.ip + ":" + this.port;
        }
    }
}

