/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.buffer.Buffer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

final class ReadableBuffer {
    private static final long MAX_INTEGER_DIV_10 = 0xCCCCCCCCCCCCCCCL;
    private static final int MARK_WATERMARK = Integer.getInteger("io.vertx.redis.parser.watermark", 16384);
    private Buffer buffer;
    private int offset;
    private int mark;

    ReadableBuffer() {
    }

    void append(Buffer chunk) {
        if (this.buffer == null || Math.min(this.mark, this.offset) == this.buffer.length()) {
            this.buffer = chunk;
            this.offset = 0;
            return;
        }
        if (this.offset >= this.mark && this.mark > MARK_WATERMARK && this.buffer.length() > this.mark) {
            this.buffer = this.buffer.getBuffer(this.mark, this.buffer.length());
            this.offset -= this.mark;
            this.mark = 0;
        }
        this.buffer.appendBuffer(chunk);
    }

    int findLineEnd() {
        int index = -1;
        for (int i = this.offset; i < this.buffer.length(); ++i) {
            if (this.buffer.getByte(i) != 10) continue;
            index = i;
            break;
        }
        return index > 0 && this.buffer.getByte(index - 1) == 13 ? index : -1;
    }

    long readLong(int end) {
        int offset;
        long value = 0L;
        boolean negative = this.buffer.getByte(this.offset) == 45;
        int n = offset = negative ? this.offset + 1 : this.offset;
        while (offset < end - 1) {
            int digit;
            if (value > 0xCCCCCCCCCCCCCCCL) {
                throw new ArithmeticException("Overflow");
            }
            if ((digit = this.buffer.getByte(offset++) - 48) < 0 || digit > 9) {
                throw new IllegalStateException("Not a digit " + (char)digit);
            }
            value = value * 10L - (long)digit;
        }
        if (!negative) {
            value = -value;
        }
        this.offset = end + 1;
        return value;
    }

    Number readNumber(int end, NumericType type) {
        Number number = null;
        if (end >= this.offset) {
            byte[] bytes = this.buffer.getBytes(this.offset, end - 1);
            switch (type) {
                case INTEGER: {
                    number = Long.parseLong(new String(bytes, StandardCharsets.US_ASCII));
                    break;
                }
                case DECIMAL: {
                    if (bytes.length == 3 && bytes[0] == 105 && bytes[1] == 110 && bytes[2] == 102) {
                        number = Double.POSITIVE_INFINITY;
                        break;
                    }
                    if (bytes.length == 4 && bytes[0] == 45 && bytes[1] == 105 && bytes[2] == 110 && bytes[3] == 102) {
                        number = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    number = Double.parseDouble(new String(bytes, StandardCharsets.US_ASCII));
                    break;
                }
                case BIGINTEGER: {
                    number = new BigInteger(bytes);
                }
            }
            this.offset = end + 1;
        }
        return number;
    }

    @Nullable String readLine(int end) {
        byte[] bytes = null;
        if (end >= this.offset) {
            bytes = this.buffer.getBytes(this.offset, end - 1);
            this.offset = end + 1;
        }
        if (bytes != null) {
            return new String(bytes, StandardCharsets.ISO_8859_1);
        }
        return null;
    }

    Buffer readBytes(int count) {
        Buffer bytes = null;
        if (this.buffer.length() - this.offset >= count) {
            bytes = this.buffer.getBuffer(this.offset, this.offset + count);
            this.offset += count;
        }
        return bytes;
    }

    byte readByte() {
        return this.buffer.getByte(this.offset++);
    }

    byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    int readableBytes() {
        return this.buffer.length() - this.offset;
    }

    void mark() {
        this.mark = this.offset;
    }

    void reset() {
        this.offset = this.mark;
    }

    int offset() {
        return this.offset;
    }

    boolean skipEOL() {
        while (this.readableBytes() > 0) {
            byte b = this.readByte();
            if (b != 13 || this.readableBytes() <= 0 || (b = this.readByte()) != 10) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.buffer != null ? this.buffer.toString() : "null";
    }

    static enum NumericType {
        INTEGER,
        DECIMAL,
        BIGINTEGER;

    }
}

