/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.ArrayStack;
import io.vertx.redis.client.impl.ParserHandler;
import io.vertx.redis.client.impl.ReadableBuffer;
import io.vertx.redis.client.impl.types.AttributeType;
import io.vertx.redis.client.impl.types.BooleanType;
import io.vertx.redis.client.impl.types.BulkType;
import io.vertx.redis.client.impl.types.ErrorType;
import io.vertx.redis.client.impl.types.Multi;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.NumberType;
import io.vertx.redis.client.impl.types.PushType;
import io.vertx.redis.client.impl.types.SimpleStringType;

public final class RESPParser
implements Handler<Buffer> {
    public static final String VERSION = "3";
    private static final long MAX_STRING_LENGTH = 0x20000000L;
    private final ParserHandler handler;
    private final ReadableBuffer buffer = new ReadableBuffer();
    private final ArrayStack stack;
    private boolean eol = true;
    private int bytesNeeded = 0;
    private boolean verbatim = false;

    RESPParser(ParserHandler handler, int maxStack) {
        this.handler = handler;
        this.stack = new ArrayStack(maxStack);
    }

    public void handle(Buffer chunk) {
        this.buffer.append(chunk);
        block12: while (this.buffer.readableBytes() >= (this.eol ? 3 : (this.bytesNeeded != -1 ? this.bytesNeeded + 2 : 0))) {
            this.buffer.mark();
            if (this.eol) {
                byte type = this.buffer.readByte();
                int start = this.buffer.offset();
                int eol = this.buffer.findLineEnd();
                if (eol == -1) {
                    this.buffer.reset();
                    break;
                }
                if (start == eol) {
                    this.buffer.reset();
                    break;
                }
                switch (type) {
                    case 43: {
                        this.handleSimpleString(start, eol);
                        continue block12;
                    }
                    case 33: 
                    case 45: {
                        this.handleError(eol);
                        continue block12;
                    }
                    case 40: 
                    case 44: 
                    case 58: {
                        this.handleNumber(type, eol);
                        continue block12;
                    }
                    case 61: {
                        this.handleBulk(eol, true);
                        continue block12;
                    }
                    case 36: {
                        this.handleBulk(eol, false);
                        continue block12;
                    }
                    case 37: 
                    case 42: 
                    case 126: {
                        this.handleMulti(type, eol);
                        continue block12;
                    }
                    case 95: {
                        this.handleNull();
                        continue block12;
                    }
                    case 35: {
                        this.handleBoolean();
                        continue block12;
                    }
                    case 124: {
                        this.handleAttribute(eol);
                        continue block12;
                    }
                    case 62: {
                        this.handlePush(eol);
                        continue block12;
                    }
                }
                this.handler.fatal(ErrorType.create("ILLEGAL_STATE Unknown RESP type " + (char)type));
                return;
            }
            if (this.bytesNeeded == 0) {
                this.handleResponse(BulkType.EMPTY, false);
            } else {
                this.handleResponse(BulkType.create(this.buffer.readBytes(this.bytesNeeded), this.verbatim), false);
                this.verbatim = false;
            }
            if (this.buffer.skipEOL()) {
                this.eol = true;
                continue;
            }
            this.buffer.reset();
        }
    }

    private void handleNumber(byte type, int eol) {
        try {
            switch (type) {
                case 58: {
                    this.handleResponse(NumberType.create(this.buffer.readNumber(eol, ReadableBuffer.NumericType.INTEGER)), false);
                    break;
                }
                case 44: {
                    this.handleResponse(NumberType.create(this.buffer.readNumber(eol, ReadableBuffer.NumericType.DECIMAL)), false);
                    break;
                }
                case 40: {
                    this.handleResponse(NumberType.create(this.buffer.readNumber(eol, ReadableBuffer.NumericType.BIGINTEGER)), false);
                }
            }
        }
        catch (RuntimeException e) {
            this.handler.fatal(e);
        }
    }

    private long handleLength(int eol) {
        long integer;
        try {
            integer = this.buffer.readLong(eol);
        }
        catch (RuntimeException e) {
            this.handler.fatal(e);
            return -1L;
        }
        if (integer > Integer.MAX_VALUE) {
            this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Multi cannot be larger 2GB elements"));
            return -1L;
        }
        if (integer < 0L) {
            if (integer == -1L) {
                this.handleResponse(null, false);
                return -1L;
            }
            this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Multi cannot have negative length"));
            return -1L;
        }
        return integer;
    }

    private void handlePush(int eol) {
        long len = this.handleLength(eol);
        if (len >= 0L) {
            if (len == 0L) {
                this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Push must have at least 1 element"));
            } else {
                this.handleResponse(PushType.create(len), true);
            }
        }
    }

    private void handleAttribute(int eol) {
        long len = this.handleLength(eol);
        if (len >= 0L) {
            if (len == 0L) {
                this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Push must have at least 1 element"));
            } else {
                this.handleResponse(AttributeType.create(len), true);
            }
        }
    }

    private void handleBoolean() {
        byte value = this.buffer.readByte();
        switch (value) {
            case 116: {
                this.buffer.skipEOL();
                this.handleResponse(BooleanType.TRUE, false);
                break;
            }
            case 102: {
                this.buffer.skipEOL();
                this.handleResponse(BooleanType.FALSE, false);
                break;
            }
            default: {
                this.handler.fatal(ErrorType.create("Invalid boolean value: " + (char)value));
            }
        }
    }

    private void handleSimpleString(int start, int eol) {
        int length = eol - start;
        if (length == 2 && this.buffer.getByte(start) == 79 && this.buffer.getByte(start + 1) == 75) {
            this.handleResponse(SimpleStringType.OK, false);
        } else {
            this.handleResponse(SimpleStringType.create(this.buffer.readLine(eol)), false);
        }
    }

    private void handleError(int eol) {
        this.handleResponse(ErrorType.create(this.buffer.readLine(eol)), false);
    }

    private void handleBulk(int eol, boolean verbatim) {
        long len = this.handleLength(eol);
        if (len >= 0L) {
            if (len > 0x20000000L) {
                this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Bulk cannot be larger than 512MB"));
                return;
            }
            this.bytesNeeded = (int)len;
            this.eol = false;
            this.verbatim = verbatim;
        }
    }

    private void handleMulti(byte type, int eol) {
        long len = this.handleLength(eol);
        if (len >= 0L) {
            if (len == 0L) {
                this.handleResponse(type == 37 ? MultiType.EMPTY_MAP : MultiType.EMPTY_MULTI, false);
            } else {
                this.handleResponse(MultiType.create(len, type == 37), true);
            }
        }
    }

    private void handleNull() {
        this.buffer.skipEOL();
        this.handleResponse(null, false);
    }

    private void handleResponse(Response response, boolean push) {
        Multi multi = (Multi)this.stack.peek();
        if (multi != null) {
            multi.add(response);
            if (push) {
                this.stack.push(response);
            } else {
                Multi m = multi;
                while (m.complete()) {
                    this.stack.pop();
                    if (this.stack.empty()) {
                        if (m.type() != ResponseType.ATTRIBUTE) {
                            this.handler.handle(m);
                        }
                        return;
                    }
                    m = (Multi)this.stack.peek();
                    if (m != null) continue;
                    this.handler.fatal(ErrorType.create("ILLEGAL_STATE Multi can't be null"));
                    return;
                }
            }
        } else if (push) {
            this.stack.push(response);
        } else {
            this.handler.handle(response);
        }
    }
}

