/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentracing;

import io.opentracing.Tracer;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.tracing.opentracing.OpenTracingTracer;
import io.vertx.tracing.opentracing.OpenTracingTracerFactory;

@DataObject
public class OpenTracingOptions
extends TracingOptions {
    private Tracer tracer;

    public OpenTracingOptions() {
        this.setFactory(OpenTracingTracerFactory.INSTANCE);
    }

    public OpenTracingOptions(Tracer tracer) {
        this.tracer = tracer;
        this.setFactory(OpenTracingTracerFactory.INSTANCE);
    }

    public OpenTracingOptions(OpenTracingOptions other) {
        this.tracer = other.tracer;
        this.setFactory(OpenTracingTracerFactory.INSTANCE);
    }

    public OpenTracingOptions(JsonObject json) {
        super(json);
        this.setFactory(OpenTracingTracerFactory.INSTANCE);
    }

    public OpenTracingOptions copy() {
        return new OpenTracingOptions(this);
    }

    Tracer getTracer() {
        return this.tracer;
    }

    VertxTracer<?, ?> buildTracer() {
        if (this.tracer != null) {
            return new OpenTracingTracer(false, this.tracer);
        }
        return new OpenTracingTracer(true, OpenTracingTracer.createDefaultTracer());
    }
}

