/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.SocketSettings;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

class SocketSettingsParser {
    private final SocketSettings settings;

    public SocketSettingsParser(ConnectionString connectionString, JsonObject config) {
        Integer sendBufferSize;
        Integer receiveBufferSize;
        Integer socketTimeoutMS;
        Integer connectTimeoutMS;
        SocketSettings.Builder settings = SocketSettings.builder();
        if (connectionString != null) {
            settings.applyConnectionString(connectionString);
        }
        if ((connectTimeoutMS = config.getInteger("connectTimeoutMS")) != null) {
            settings.connectTimeout(connectTimeoutMS.intValue(), TimeUnit.MILLISECONDS);
        }
        if ((socketTimeoutMS = config.getInteger("socketTimeoutMS")) != null) {
            settings.readTimeout(socketTimeoutMS.intValue(), TimeUnit.MILLISECONDS);
        }
        if ((receiveBufferSize = config.getInteger("receiveBufferSize")) != null) {
            settings.receiveBufferSize(receiveBufferSize.intValue());
        }
        if ((sendBufferSize = config.getInteger("sendBufferSize")) != null) {
            settings.sendBufferSize(sendBufferSize.intValue());
        }
        this.settings = settings.build();
    }

    public SocketSettings settings() {
        return this.settings;
    }
}

