/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

@DataObject
public class IndexOptions {
    public static final boolean DEFAULT_BACKGROUD = false;
    public static final boolean DEFAULT_UNIQUE = false;
    public static final boolean DEFAULT_SPARSE = false;
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Long expireAfterSeconds;
    private Integer version;
    private JsonObject weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textVersion;
    private Integer sphereVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private Double bucketSize;
    private JsonObject storageEngine;
    private JsonObject partialFilterExpression;

    public IndexOptions() {
        this.background = false;
        this.unique = false;
        this.sparse = false;
    }

    public IndexOptions(IndexOptions options) {
        this.background = options.background;
        this.unique = options.unique;
        this.name = options.name;
        this.sparse = options.sparse;
        this.expireAfterSeconds = options.expireAfterSeconds;
        this.version = options.version;
        this.weights = options.weights;
        this.defaultLanguage = options.defaultLanguage;
        this.languageOverride = options.languageOverride;
        this.textVersion = options.textVersion;
        this.sphereVersion = options.sphereVersion;
        this.bits = options.bits;
        this.min = options.min;
        this.max = options.max;
        this.bucketSize = options.bucketSize;
        this.storageEngine = options.storageEngine;
        this.partialFilterExpression = options.partialFilterExpression;
    }

    public IndexOptions(JsonObject options) {
        this.background = options.getBoolean("background", Boolean.valueOf(false));
        this.unique = options.getBoolean("unique", Boolean.valueOf(false));
        this.name = options.getString("name");
        this.sparse = options.getBoolean("sparse", Boolean.valueOf(false));
        this.expireAfterSeconds = options.getLong("expireAfterSeconds");
        this.version = options.getInteger("version");
        this.weights = options.getJsonObject("weights");
        this.defaultLanguage = options.getString("defaultLanguage");
        this.languageOverride = options.getString("languageOverride");
        this.textVersion = options.getInteger("textVersion");
        this.sphereVersion = options.getInteger("sphereVersion");
        this.bits = options.getInteger("bits");
        this.min = options.getDouble("min");
        this.max = options.getDouble("max");
        this.bucketSize = options.getDouble("bucketSize");
        this.storageEngine = options.getJsonObject("storageEngine");
        this.partialFilterExpression = options.getJsonObject("partialFilterExpression");
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("background", (Object)this.background);
        json.put("unique", (Object)this.unique);
        json.put("sparse", (Object)this.sparse);
        if (this.name != null) {
            json.put("name", (Object)this.name);
        }
        if (this.expireAfterSeconds != null) {
            json.put("expireAfterSeconds", (Object)this.expireAfterSeconds);
        }
        if (this.version != null) {
            json.put("version", (Object)this.version);
        }
        if (this.weights != null) {
            json.put("weights", (Object)this.weights);
        }
        if (this.defaultLanguage != null) {
            json.put("defaultLanguage", (Object)this.defaultLanguage);
        }
        if (this.languageOverride != null) {
            json.put("languageOverride", (Object)this.languageOverride);
        }
        if (this.textVersion != null) {
            json.put("textVersion", (Object)this.textVersion);
        }
        if (this.sphereVersion != null) {
            json.put("sphereVersion", (Object)this.sphereVersion);
        }
        if (this.bits != null) {
            json.put("bits", (Object)this.bits);
        }
        if (this.min != null) {
            json.put("min", (Object)this.min);
        }
        if (this.max != null) {
            json.put("max", (Object)this.max);
        }
        if (this.bucketSize != null) {
            json.put("bucketSize", (Object)this.bucketSize);
        }
        if (this.storageEngine != null) {
            json.put("storageEngine", (Object)this.storageEngine);
        }
        if (this.partialFilterExpression != null) {
            json.put("partialFilterExpression", (Object)this.partialFilterExpression);
        }
        return json;
    }

    public boolean isBackground() {
        return this.background;
    }

    public IndexOptions background(boolean background) {
        this.background = background;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public IndexOptions unique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public IndexOptions name(String name) {
        this.name = name;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public IndexOptions sparse(boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Long getExpireAfter(TimeUnit timeUnit) {
        if (this.expireAfterSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.expireAfterSeconds, TimeUnit.SECONDS);
    }

    public IndexOptions expireAfter(Long expireAfter, TimeUnit timeUnit) {
        this.expireAfterSeconds = expireAfter == null ? null : Long.valueOf(TimeUnit.SECONDS.convert(expireAfter, timeUnit));
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public IndexOptions version(Integer version) {
        this.version = version;
        return this;
    }

    public JsonObject getWeights() {
        return this.weights;
    }

    public IndexOptions weights(JsonObject weights) {
        this.weights = weights;
        return this;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public IndexOptions defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public IndexOptions languageOverride(String languageOverride) {
        this.languageOverride = languageOverride;
        return this;
    }

    public Integer getTextVersion() {
        return this.textVersion;
    }

    public IndexOptions textVersion(Integer textVersion) {
        this.textVersion = textVersion;
        return this;
    }

    public Integer getSphereVersion() {
        return this.sphereVersion;
    }

    public IndexOptions sphereVersion(Integer sphereVersion) {
        this.sphereVersion = sphereVersion;
        return this;
    }

    public Integer getBits() {
        return this.bits;
    }

    public IndexOptions bits(Integer bits) {
        this.bits = bits;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public IndexOptions min(Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public IndexOptions max(Double max) {
        this.max = max;
        return this;
    }

    public Double getBucketSize() {
        return this.bucketSize;
    }

    public IndexOptions bucketSize(Double bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public JsonObject getStorageEngine() {
        return this.storageEngine;
    }

    public IndexOptions storageEngine(JsonObject storageEngine) {
        this.storageEngine = storageEngine;
        return this;
    }

    public JsonObject getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public IndexOptions partialFilterExpression(JsonObject partialFilterExpression) {
        this.partialFilterExpression = partialFilterExpression;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexOptions options = (IndexOptions)o;
        if (this.background != options.background) {
            return false;
        }
        if (this.unique != options.unique) {
            return false;
        }
        if (this.name != null ? !this.name.equals(options.name) : options.name != null) {
            return false;
        }
        if (this.sparse != options.sparse) {
            return false;
        }
        if (this.expireAfterSeconds != null ? !this.expireAfterSeconds.equals(options.expireAfterSeconds) : options.expireAfterSeconds != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(options.version) : options.version != null) {
            return false;
        }
        if (this.weights != null ? !this.weights.equals((Object)options.weights) : options.weights != null) {
            return false;
        }
        if (this.defaultLanguage != null ? !this.defaultLanguage.equals(options.defaultLanguage) : options.defaultLanguage != null) {
            return false;
        }
        if (this.languageOverride != null ? !this.languageOverride.equals(options.languageOverride) : options.languageOverride != null) {
            return false;
        }
        if (this.textVersion != null ? !this.textVersion.equals(options.textVersion) : options.textVersion != null) {
            return false;
        }
        if (this.sphereVersion != null ? !this.sphereVersion.equals(options.sphereVersion) : options.sphereVersion != null) {
            return false;
        }
        if (this.bits != null ? !this.bits.equals(options.bits) : options.bits != null) {
            return false;
        }
        if (this.min != null ? !this.min.equals(options.min) : options.min != null) {
            return false;
        }
        if (this.max != null ? !this.max.equals(options.max) : options.max != null) {
            return false;
        }
        if (this.bucketSize != null ? !this.bucketSize.equals(options.bucketSize) : options.bucketSize != null) {
            return false;
        }
        if (this.storageEngine != null ? !this.storageEngine.equals((Object)options.storageEngine) : options.storageEngine != null) {
            return false;
        }
        return !(this.partialFilterExpression != null ? !this.partialFilterExpression.equals((Object)options.partialFilterExpression) : options.partialFilterExpression != null);
    }

    public int hashCode() {
        int result = this.background ? 1 : 0;
        result = 31 * result + (this.unique ? 1 : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.sparse ? 1 : 0);
        result = 31 * result + (this.expireAfterSeconds != null ? this.expireAfterSeconds.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.weights != null ? this.weights.hashCode() : 0);
        result = 31 * result + (this.defaultLanguage != null ? this.defaultLanguage.hashCode() : 0);
        result = 31 * result + (this.languageOverride != null ? this.languageOverride.hashCode() : 0);
        result = 31 * result + (this.textVersion != null ? this.textVersion.hashCode() : 0);
        result = 31 * result + (this.sphereVersion != null ? this.sphereVersion.hashCode() : 0);
        result = 31 * result + (this.bits != null ? this.bits.hashCode() : 0);
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        result = 31 * result + (this.bucketSize != null ? this.bucketSize.hashCode() : 0);
        result = 31 * result + (this.storageEngine != null ? this.storageEngine.hashCode() : 0);
        result = 31 * result + (this.partialFilterExpression != null ? this.partialFilterExpression.hashCode() : 0);
        return result;
    }
}

