/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.sql.SQLOptions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCExecute
extends AbstractJDBCAction<Void> {
    private final String sql;

    public JDBCExecute(Vertx vertx, SQLOptions options, ContextInternal ctx, String sql) {
        super(vertx, options, ctx);
        this.sql = sql;
    }

    @Override
    public Void execute(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            this.applyStatementOptions(stmt);
            boolean isResultSet = stmt.execute(this.sql);
            if (isResultSet) {
                while (stmt.getMoreResults()) {
                    ResultSet rs = stmt.getResultSet();
                    Throwable throwable = null;
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            Void void_ = null;
            return void_;
        }
    }

    @Override
    protected String name() {
        return "execute";
    }
}

