/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client;

import io.grpc.ClientCall;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.impl.BridgeMessageDecoder;
import io.vertx.grpc.common.impl.BridgeMessageEncoder;
import io.vertx.grpc.common.impl.ReadStreamAdapter;
import io.vertx.grpc.common.impl.Utils;
import io.vertx.grpc.common.impl.WriteStreamAdapter;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class VertxClientCall<RequestT, ResponseT>
extends ClientCall<RequestT, ResponseT> {
    private final GrpcClient client;
    private final SocketAddress server;
    private final Executor exec;
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final String encoding;
    private final Compressor compressor;
    private Future<GrpcClientRequest<RequestT, ResponseT>> fut;
    private ClientCall.Listener<ResponseT> listener;
    private WriteStreamAdapter<RequestT> writeAdapter;
    private ReadStreamAdapter<ResponseT> readAdapter;
    private GrpcClientRequest<RequestT, ResponseT> request;
    private GrpcClientResponse<RequestT, ResponseT> grpcResponse;

    VertxClientCall(GrpcClient client, SocketAddress server, final Executor exec, MethodDescriptor<RequestT, ResponseT> methodDescriptor, String encoding, Compressor compressor) {
        this.client = client;
        this.server = server;
        this.exec = exec;
        this.methodDescriptor = methodDescriptor;
        this.encoding = encoding;
        this.compressor = compressor;
        this.writeAdapter = new WriteStreamAdapter<RequestT>(){

            protected void handleReady() {
                VertxClientCall.this.listener.onReady();
            }
        };
        this.readAdapter = new ReadStreamAdapter<ResponseT>(){

            protected void handleClose() {
                Status status = Status.fromCodeValue((int)((VertxClientCall)VertxClientCall.this).grpcResponse.status().code);
                Metadata trailers = Utils.readMetadata((MultiMap)VertxClientCall.this.grpcResponse.trailers());
                VertxClientCall.this.doClose(status, trailers);
            }

            protected void handleMessage(ResponseT msg) {
                if (exec == null) {
                    VertxClientCall.this.listener.onMessage(msg);
                } else {
                    exec.execute(() -> VertxClientCall.this.listener.onMessage(msg));
                }
            }
        };
    }

    public boolean isReady() {
        return this.writeAdapter.isReady();
    }

    public void start(ClientCall.Listener<ResponseT> responseListener, Metadata headers) {
        this.listener = responseListener;
        this.fut = this.client.request(this.server, this.methodDescriptor);
        this.fut.onComplete(ar1 -> {
            if (ar1.succeeded()) {
                this.request = (GrpcClientRequest)ar1.result();
                Utils.writeMetadata((Metadata)headers, (MultiMap)this.request.headers());
                if (this.encoding != null) {
                    this.request.encoding(this.encoding);
                }
                Future<GrpcClientResponse<RequestT, ResponseT>> responseFuture = this.request.response();
                responseFuture.onComplete(ar2 -> {
                    if (ar2.succeeded()) {
                        this.grpcResponse = (GrpcClientResponse)ar2.result();
                        String respEncoding = this.grpcResponse.encoding();
                        Decompressor decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(respEncoding);
                        BridgeMessageDecoder decoder = new BridgeMessageDecoder(this.methodDescriptor.getResponseMarshaller(), decompressor);
                        Metadata responseHeaders = Utils.readMetadata((MultiMap)this.grpcResponse.headers());
                        if (this.exec == null) {
                            responseListener.onHeaders(responseHeaders);
                        } else {
                            this.exec.execute(() -> responseListener.onHeaders(responseHeaders));
                        }
                        this.readAdapter.init(this.grpcResponse, decoder);
                    } else {
                        Throwable err = ar2.cause();
                        if (err instanceof StreamResetException) {
                            StreamResetException reset = (StreamResetException)err;
                            switch ((int)reset.getCode()) {
                                case 8: {
                                    this.doClose(Status.CANCELLED, new Metadata());
                                    break;
                                }
                                default: {
                                    System.out.println("handle me");
                                    break;
                                }
                            }
                        } else {
                            System.out.println("handle me");
                        }
                    }
                });
                this.writeAdapter.init(this.request, (GrpcMessageEncoder)new BridgeMessageEncoder(this.methodDescriptor.getRequestMarshaller(), this.compressor));
            }
        });
    }

    public void doClose(Status status, Metadata trailers) {
        Runnable cmd = () -> this.listener.onClose(status, trailers);
        if (this.exec == null) {
            cmd.run();
        } else {
            this.exec.execute(cmd);
        }
    }

    public void request(int numMessages) {
        this.readAdapter.request(numMessages);
    }

    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        this.fut.onSuccess(req -> req.cancel());
    }

    public void halfClose() {
        this.fut.onSuccess(req -> req.end());
    }

    public void sendMessage(RequestT message) {
        this.fut.onSuccess(v -> this.writeAdapter.write(message));
    }
}

