/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.db2client.impl.codec.DB2ParamDesc;
import io.vertx.db2client.impl.codec.DB2RowDesc;
import io.vertx.db2client.impl.drda.Cursor;
import io.vertx.db2client.impl.drda.Section;
import io.vertx.sqlclient.impl.ParamDesc;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.TupleInternal;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

class DB2PreparedStatement
implements PreparedStatement {
    private static final Logger LOG = LoggerFactory.getLogger(DB2PreparedStatement.class);
    final String sql;
    final DB2ParamDesc paramDesc;
    final DB2RowDesc rowDesc;
    final Section section;
    private final Map<String, QueryInstance> activeQueries = new ConcurrentHashMap<String, QueryInstance>(4);

    DB2PreparedStatement(String sql, DB2ParamDesc paramDesc, DB2RowDesc rowDesc, Section section) {
        this.paramDesc = paramDesc;
        this.rowDesc = rowDesc;
        this.sql = sql;
        this.section = section;
    }

    public ParamDesc paramDesc() {
        return this.paramDesc;
    }

    public RowDesc rowDesc() {
        return this.rowDesc;
    }

    public String sql() {
        return this.sql;
    }

    public String prepare(TupleInternal values) {
        return this.paramDesc.prepare(values);
    }

    QueryInstance getQueryInstance(String cursorId) {
        cursorId = cursorId == null ? UUID.randomUUID().toString() : cursorId;
        return this.activeQueries.computeIfAbsent(cursorId, c -> new QueryInstance((String)c));
    }

    void closeQuery(QueryInstance query) {
        LOG.debug((Object)("Closing queryInstance " + query.cursorId));
        this.activeQueries.remove(query.cursorId);
    }

    void close() {
        this.activeQueries.values().stream().forEach(this::closeQuery);
        this.section.release();
    }

    public static class QueryInstance {
        final String cursorId;
        long queryInstanceId;
        Cursor cursor;

        QueryInstance(String cursorId) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating new queryInstance with id=" + cursorId));
            }
            this.cursorId = cursorId;
        }
    }
}

