/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.proxy;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.proxy.TestProxyBase;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class Socks4Proxy
extends TestProxyBase {
    private static final Logger log = LoggerFactory.getLogger(Socks4Proxy.class);
    private static final Buffer clientRequest = Buffer.buffer((byte[])new byte[]{4, 1});
    private static final Buffer connectResponse = Buffer.buffer((byte[])new byte[]{0, 90, 0, 0, 0, 0, 0, 0});
    private static final Buffer errorResponse = Buffer.buffer((byte[])new byte[]{0, 91, 0, 0, 0, 0, 0, 0});
    private static final int PORT = 11080;
    private NetServer server;

    public Socks4Proxy(String username) {
        super(username);
    }

    @Override
    public Socks4Proxy start(Vertx vertx) throws Exception {
        NetServerOptions options = new NetServerOptions();
        options.setHost("localhost").setPort(11080);
        this.server = vertx.createNetServer(options);
        this.server.connectHandler(socket -> socket.handler(buffer -> {
            if (!buffer.getBuffer(0, clientRequest.length()).equals(clientRequest)) {
                throw new IllegalStateException("expected " + this.toHex(clientRequest) + ", got " + this.toHex((Buffer)buffer));
            }
            log.debug((Object)("got request: " + this.toHex((Buffer)buffer)));
            int port = buffer.getUnsignedShort(2);
            String ip = this.getByte4(buffer.getBuffer(4, 8));
            String authUsername = this.getString(buffer.getBuffer(8, buffer.length()));
            if (this.username != null && !authUsername.equals(this.username)) {
                log.debug((Object)"auth failed");
                log.debug((Object)("writing: " + this.toHex(errorResponse)));
                socket.write((Object)errorResponse);
                socket.close();
            } else {
                String host = ip.equals("0.0.0.1") ? this.getString(buffer.getBuffer(9 + authUsername.length(), buffer.length())) : ip;
                log.debug((Object)("connect: " + host + ":" + port));
                socket.handler(null);
                this.lastUri = host + ":" + port;
                if (this.forceUri != null) {
                    host = this.forceUri.substring(0, this.forceUri.indexOf(58));
                    port = Integer.valueOf(this.forceUri.substring(this.forceUri.indexOf(58) + 1));
                }
                log.debug((Object)("connecting to " + host + ":" + port));
                NetClient netClient = vertx.createNetClient(new NetClientOptions());
                netClient.connect(port, host, result -> {
                    if (result.succeeded()) {
                        log.debug((Object)("writing: " + this.toHex(connectResponse)));
                        socket.write((Object)connectResponse);
                        log.debug((Object)"connected, starting pump");
                        NetSocket clientSocket = (NetSocket)result.result();
                        socket.closeHandler(v -> clientSocket.close());
                        clientSocket.closeHandler(v -> socket.close());
                        Pump.pump((ReadStream)socket, (WriteStream)clientSocket).start();
                        Pump.pump((ReadStream)clientSocket, (WriteStream)socket).start();
                    } else {
                        log.error((Object)"exception", result.cause());
                        socket.handler(null);
                        log.debug((Object)("writing: " + this.toHex(errorResponse)));
                        socket.write((Object)errorResponse);
                        socket.close();
                    }
                });
            }
        }));
        CompletableFuture fut = new CompletableFuture();
        this.server.listen(ar -> {
            if (ar.succeeded()) {
                fut.complete(null);
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        fut.get(10L, TimeUnit.SECONDS);
        log.debug((Object)"socks4a server started");
        return this;
    }

    private String getString(Buffer buffer) {
        String string = buffer.toString();
        return string.substring(0, string.indexOf(0));
    }

    private String getByte4(Buffer buffer) {
        return String.format("%d.%d.%d.%d", buffer.getByte(0), buffer.getByte(1), buffer.getByte(2), buffer.getByte(3));
    }

    private String toHex(Buffer buffer) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length(); ++i) {
            sb.append(String.format("%02X ", buffer.getByte(i)));
        }
        return sb.toString();
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Override
    public int getPort() {
        return 11080;
    }
}

