/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.proxy;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.proxy.TestProxyBase;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class HttpProxy
extends TestProxyBase {
    private static final int PORT = 13128;
    private static final Logger log = LoggerFactory.getLogger(HttpProxy.class);
    private HttpServer server;
    private int error = 0;
    private MultiMap lastRequestHeaders = null;
    private HttpMethod lastMethod;

    public HttpProxy(String username) {
        super(username);
    }

    @Override
    public HttpProxy start(Vertx vertx) throws Exception {
        HttpServerOptions options = new HttpServerOptions();
        options.setHost("localhost").setPort(13128);
        this.server = vertx.createHttpServer(options);
        this.server.requestHandler(request -> {
            HttpMethod method = request.method();
            String uri = request.uri();
            if (this.username != null) {
                String auth = request.getHeader("Proxy-Authorization");
                String expected = "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.username).getBytes());
                if (auth == null || !auth.equals(expected)) {
                    request.response().setStatusCode(407).end("proxy authentication failed");
                    return;
                }
            }
            this.lastRequestHeaders = HttpHeaders.headers().addAll(request.headers());
            if (this.error != 0) {
                request.response().setStatusCode(this.error).end("proxy request failed");
            } else if (method == HttpMethod.CONNECT) {
                if (!uri.contains(":")) {
                    request.response().setStatusCode(403).end("invalid request");
                } else {
                    int port;
                    this.lastUri = uri;
                    this.lastMethod = HttpMethod.CONNECT;
                    if (this.forceUri != null) {
                        uri = this.forceUri;
                    }
                    String[] split = uri.split(":");
                    String host = split[0];
                    try {
                        port = Integer.parseInt(split[1]);
                    }
                    catch (NumberFormatException ex) {
                        port = 443;
                    }
                    if (port == 8080 || port < 1024 && port != 443) {
                        request.response().setStatusCode(403).end("access to port denied");
                        return;
                    }
                    NetClientOptions netOptions = new NetClientOptions();
                    NetClient netClient = vertx.createNetClient(netOptions);
                    netClient.connect(port, host, ar1 -> {
                        if (ar1.succeeded()) {
                            request.toNetSocket().onComplete(ar2 -> {
                                if (ar2.succeeded()) {
                                    NetSocket serverSocket = (NetSocket)ar2.result();
                                    NetSocket clientSocket = (NetSocket)ar1.result();
                                    serverSocket.closeHandler(v -> clientSocket.close());
                                    clientSocket.closeHandler(v -> serverSocket.close());
                                    Pump.pump((ReadStream)serverSocket, (WriteStream)clientSocket).start();
                                    Pump.pump((ReadStream)clientSocket, (WriteStream)serverSocket).start();
                                }
                            });
                        } else {
                            request.response().setStatusCode(403).end("request failed");
                        }
                    });
                }
            } else if (method == HttpMethod.GET) {
                this.lastUri = uri;
                this.lastMethod = HttpMethod.GET;
                if (this.forceUri != null) {
                    uri = this.forceUri;
                }
                HttpClient client = vertx.createHttpClient();
                RequestOptions opts = new RequestOptions();
                opts.setAbsoluteURI(uri);
                client.request(opts).compose(req -> {
                    for (String name : request.headers().names()) {
                        if (name.equals("Proxy-Authorization")) continue;
                        req.putHeader(name, request.headers().get(name));
                    }
                    return req.send();
                }).onComplete(ar1 -> {
                    if (ar1.succeeded()) {
                        HttpClientResponse resp = (HttpClientResponse)ar1.result();
                        for (String name : resp.headers().names()) {
                            request.response().putHeader(name, (Iterable)resp.headers().getAll(name));
                        }
                        resp.body(ar2 -> {
                            if (ar2.succeeded()) {
                                request.response().end((Buffer)ar2.result());
                            } else {
                                request.response().setStatusCode(500).end(ar2.cause().toString() + " on client request");
                            }
                        });
                    } else {
                        Throwable e = ar1.cause();
                        log.debug((Object)"exception", e);
                        int status = e instanceof UnknownHostException ? 504 : 400;
                        request.response().setStatusCode(status).end(e.toString() + " on client request");
                    }
                });
            } else {
                request.response().setStatusCode(405).end("method not supported");
            }
        });
        CompletableFuture fut = new CompletableFuture();
        this.server.listen(ar -> {
            if (ar.succeeded()) {
                fut.complete(null);
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        fut.get(10L, TimeUnit.SECONDS);
        return this;
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Override
    public int getPort() {
        return 13128;
    }

    @Override
    public HttpMethod getLastMethod() {
        return this.lastMethod;
    }

    @Override
    public MultiMap getLastRequestHeaders() {
        return this.lastRequestHeaders;
    }

    public HttpProxy setError(int error) {
        this.error = error;
        return this;
    }
}

