/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.NetUtil;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import io.vertx.test.netty.TestLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.cert.Certificate;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPOutputStream;
import javax.security.cert.X509Certificate;
import org.junit.Assert;

public class TestUtils {
    public static final File MAVEN_TARGET_DIR = TestUtils.findMavenTargetDir();
    public static final String NON_ROUTABLE_HOST = "10.0.0.0";
    private static Random random = new Random();

    private static File findMavenTargetDir() {
        File buildDir;
        String buildDirPath = System.getProperty("buildDirectory");
        if (buildDirPath != null && (buildDir = new File(buildDirPath)).exists()) {
            return buildDir;
        }
        try {
            URL loc = TestUtils.class.getProtectionDomain().getCodeSource().getLocation();
            return new File(loc.toURI()).getParentFile();
        }
        catch (URISyntaxException e) {
            return new File("target");
        }
    }

    public static Buffer randomBuffer(int length) {
        return TestUtils.randomBuffer(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length) {
        return TestUtils.randomByteArray(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length, boolean avoid, byte avoidByte) {
        byte[] line = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte rand;
            do {
                rand = TestUtils.randomByte();
            } while (avoid && rand == avoidByte);
            line[i] = rand;
        }
        return line;
    }

    public static Buffer randomBuffer(int length, boolean avoid, byte avoidByte) {
        byte[] line = TestUtils.randomByteArray(length, avoid, avoidByte);
        return Buffer.buffer((byte[])line);
    }

    public static byte randomByte() {
        return (byte)((int)(Math.random() * 255.0) - 128);
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomPortInt() {
        return random.nextInt(65536);
    }

    public static int randomHighPortInt() {
        return random.nextInt(64512) + 1024;
    }

    public static int randomPositiveInt() {
        int rand;
        while ((rand = random.nextInt()) <= 0) {
        }
        return rand;
    }

    public static long randomPositiveLong() {
        long rand;
        while ((rand = random.nextLong()) <= 0L) {
        }
        return rand;
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static char randomChar() {
        return (char)random.nextInt(16);
    }

    public static short randomShort() {
        return (short)random.nextInt(32768);
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static String randomUnicodeString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c;
            while ((c = (char)(65535.0 * Math.random())) >= '\ufffe' && c <= '\uffff' || c >= '\ud800' && c <= '\udfff') {
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String randomAlphaString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = (char)(65.0 + 25.0 * Math.random());
            builder.append(c);
        }
        return builder.toString();
    }

    public static Http2Settings randomHttp2Settings() {
        long headerTableSize = 10L + (long)TestUtils.randomPositiveInt() % 0xFFFFFFF5L;
        boolean enablePush = TestUtils.randomBoolean();
        long maxConcurrentStreams = 10L + TestUtils.randomPositiveLong() % 0xFFFFFFF5L;
        int initialWindowSize = 10 + TestUtils.randomPositiveInt() % 0x7FFFFFF5;
        int maxFrameSize = 16384 + TestUtils.randomPositiveInt() % 0xFFBFFF;
        long maxHeaderListSize = 10L + TestUtils.randomPositiveLong() % 0xFFFFFFF5L;
        Http2Settings settings = new Http2Settings();
        settings.setHeaderTableSize(headerTableSize);
        settings.setPushEnabled(enablePush);
        settings.setMaxConcurrentStreams(maxConcurrentStreams);
        settings.setInitialWindowSize(initialWindowSize);
        settings.setMaxFrameSize(maxFrameSize);
        settings.setMaxHeaderListSize(maxHeaderListSize);
        settings.set(7, TestUtils.randomPositiveLong() & 0xFFFFFFFFL);
        return settings;
    }

    public static MultiMap randomMultiMap(int num) {
        MultiMap multiMap = MultiMap.caseInsensitiveMultiMap();
        for (int i = 0; i < num; ++i) {
            String key;
            while (multiMap.contains(key = TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())).toLowerCase())) {
            }
            multiMap.set(key, TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())));
        }
        return multiMap;
    }

    public static <E extends Enum<E>> Set<E> randomEnumSet(Class<E> enumType) {
        EnumSet<Enum> set = EnumSet.noneOf(enumType);
        for (Enum e : EnumSet.allOf(enumType)) {
            if (TestUtils.randomPositiveInt() % 2 != 1) continue;
            set.add(e);
        }
        return set;
    }

    public static <E> E randomElement(E[] array) {
        return array[TestUtils.randomPositiveInt() % array.length];
    }

    public static boolean byteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static void assertIllegalArgumentException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void assertNullPointerException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void assertIllegalStateException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void assertIllegalStateExceptionAsync(Supplier<Future<?>> runnable) {
        Future<?> fut = runnable.get();
        Assert.assertTrue((boolean)fut.failed());
        Assert.assertTrue((boolean)(fut.cause() instanceof IllegalStateException));
    }

    public static void assertIndexOutOfBoundsException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static byte[] compressGzip(String source) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        gos.write(source.getBytes());
        gos.close();
        return baos.toByteArray();
    }

    public static KeyCertOptions randomKeyCertOptions() {
        JksOptions keyCertOptions;
        switch (TestUtils.randomPositiveInt() % 3) {
            case 0: {
                keyCertOptions = new JksOptions();
                String jksPassword = TestUtils.randomAlphaString(100);
                keyCertOptions.setPassword(jksPassword);
                break;
            }
            case 1: {
                keyCertOptions = new PemKeyCertOptions();
                Buffer keyValue = TestUtils.randomBuffer(100);
                ((PemKeyCertOptions)keyCertOptions).setKeyValue(keyValue);
                break;
            }
            default: {
                keyCertOptions = new PfxOptions();
                String pfxPassword = TestUtils.randomAlphaString(100);
                ((PfxOptions)keyCertOptions).setPassword(pfxPassword);
            }
        }
        return keyCertOptions;
    }

    public static TrustOptions randomTrustOptions() {
        JksOptions trustOptions;
        switch (TestUtils.randomPositiveInt() % 3) {
            case 0: {
                trustOptions = new JksOptions();
                String tsPassword = TestUtils.randomAlphaString(100);
                trustOptions.setPassword(tsPassword);
                break;
            }
            case 1: {
                trustOptions = new PemTrustOptions();
                Buffer keyValue = TestUtils.randomBuffer(100);
                ((PemTrustOptions)trustOptions).addCertValue(keyValue);
                break;
            }
            default: {
                trustOptions = new PfxOptions();
                String pfxPassword = TestUtils.randomAlphaString(100);
                ((PfxOptions)trustOptions).setPassword(pfxPassword);
            }
        }
        return trustOptions;
    }

    public static Buffer leftPad(int padding, Buffer buffer) {
        return Buffer.buffer((ByteBuf)Unpooled.buffer().writerIndex(padding).readerIndex(padding).writeBytes(buffer.getByteBuf()));
    }

    public static String cnOf(Certificate cert) throws Exception {
        if (cert instanceof java.security.cert.X509Certificate) {
            String dn = ((java.security.cert.X509Certificate)cert).getSubjectX500Principal().getName();
            List names = KeyStoreHelper.getX509CertificateCommonNames((String)dn);
            return names.isEmpty() ? null : (String)names.get(0);
        }
        return null;
    }

    public static String cnOf(X509Certificate cert) throws Exception {
        String dn = cert.getSubjectDN().getName();
        List names = KeyStoreHelper.getX509CertificateCommonNames((String)dn);
        return names.isEmpty() ? null : (String)names.get(0);
    }

    public static String loopbackAddress() {
        return NetUtil.LOCALHOST4.getHostAddress();
    }

    public static File tmpFile(String suffix) throws Exception {
        File tmp = Files.createTempFile("vertx", suffix, new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)tmp.delete());
        return tmp;
    }

    public static File tmpFile(String suffix, long length) throws Exception {
        File tmp = File.createTempFile("vertx", suffix);
        tmp.deleteOnExit();
        RandomAccessFile f = new RandomAccessFile(tmp, "rw");
        f.setLength(length);
        return tmp;
    }

    public static String getJarEntryName(Path path) {
        return StreamSupport.stream(path.spliterator(), false).map(p -> "" + p.getName(0)).collect(Collectors.joining("/"));
    }

    public static TestLoggerFactory testLogging(Runnable runnable) {
        InternalLoggerFactory prev = InternalLoggerFactory.getDefaultFactory();
        TestLoggerFactory factory = new TestLoggerFactory();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)factory);
        try {
            runnable.run();
        }
        finally {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)prev);
        }
        return factory;
    }

    public static boolean isECCSupportedByVM() {
        try {
            KeyFactory.getInstance("EC");
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }
}

