/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.test.core.DetectFileDescriptorLeaks;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.assertj.core.api.Assertions;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class FileDescriptorLeakDetectorRule
implements TestRule {
    private static final MBeanServer MBEAN_SERVER;
    private static final ObjectName MBEAN_NAME;
    private static final MBeanAttributeInfo OPEN_FD_INFO;

    public Statement apply(final Statement statement, Description description) {
        final DetectFileDescriptorLeaks detectFileDescriptorsLeaks = (DetectFileDescriptorLeaks)description.getAnnotation(DetectFileDescriptorLeaks.class);
        if (detectFileDescriptorsLeaks == null || OPEN_FD_INFO == null) {
            return statement;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Long> baseLine = new ArrayList<Long>();
                long baseline = detectFileDescriptorsLeaks.baseline();
                System.out.println("*** Starting file leak descriptor test with " + baseline + " iterations");
                int i = 0;
                while ((long)i < baseline) {
                    statement.evaluate();
                    long openFd = (Long)MBEAN_SERVER.getAttribute(MBEAN_NAME, OPEN_FD_INFO.getName());
                    baseLine.add(openFd);
                    ++i;
                }
                long maxBaseLine = FileDescriptorLeakDetectorRule.getMax(baseLine);
                System.out.println("*** Open file descriptor max open file descriptors " + maxBaseLine);
                ArrayList<Long> iterations = new ArrayList<Long>();
                long a = detectFileDescriptorsLeaks.iterations();
                int i2 = 0;
                while ((long)i2 < a) {
                    statement.evaluate();
                    long openFd = (Long)MBEAN_SERVER.getAttribute(MBEAN_NAME, OPEN_FD_INFO.getName());
                    System.out.println("*** Open file descriptor iteration " + (i2 + 1) + "/" + a + " " + openFd + " open file descriptors");
                    iterations.add(openFd);
                    ++i2;
                }
                long averageEvaluations = FileDescriptorLeakDetectorRule.getAverage(iterations);
                System.out.println("*** Open file descriptor open file descriptors average " + averageEvaluations);
                Assertions.assertThat((long)averageEvaluations).isLessThanOrEqualTo(maxBaseLine);
            }
        };
    }

    private static long getAverage(List<Long> values) {
        return Double.valueOf(values.stream().mapToLong(v -> v).average().orElseThrow(IllegalStateException::new)).longValue();
    }

    private static long getMax(List<Long> values) {
        return values.stream().mapToLong(v -> v).max().orElseThrow(IllegalStateException::new);
    }

    static {
        MBeanServer server = null;
        ObjectName name = null;
        MBeanAttributeInfo openFdInfo = null;
        try {
            server = ManagementFactory.getPlatformMBeanServer();
            name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            MBeanInfo info = server.getMBeanInfo(name);
            openFdInfo = Stream.of(info.getAttributes()).filter(attrInfo -> attrInfo.getName().equals("OpenFileDescriptorCount") && attrInfo.getType().equals("long") && attrInfo.isReadable()).findFirst().orElse(null);
        }
        catch (JMException jMException) {
            // empty catch block
        }
        MBEAN_SERVER = server;
        MBEAN_NAME = name;
        OPEN_FD_INFO = openFdInfo;
    }
}

