/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import org.junit.Test;

public class NettyCompatTest
extends VertxTestBase {
    @Test
    public void testAddressResolver() {
        VertxInternal vertx = (VertxInternal)this.vertx;
        vertx.resolveAddress("localhost", this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testHttp2() {
        this.vertx.createHttpServer(new HttpServerOptions().setUseAlpn(true).setSsl(true).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions()).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get())).requestHandler(req -> req.response().end("OK")).listen(8443, "localhost", this.onSuccess(s -> {
            HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions()).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()));
            client.request(HttpMethod.GET, 8443, "localhost", "/somepath", this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.bodyHandler(buff -> {
                this.assertEquals("OK", buff.toString());
                this.testComplete();
            })))));
        }));
        this.await();
    }
}

