/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.it.CustomExecutorServiceFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CustomExecutorService
extends ThreadPoolExecutor {
    public static final ThreadLocal<Boolean> executing = ThreadLocal.withInitial(() -> false);

    public CustomExecutorService(ThreadFactory threadFactory, int corePoolSize, int maximumPoolSize) {
        super(corePoolSize, maximumPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        executing.set(true);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        executing.set(false);
    }

    @Override
    protected void terminated() {
        CustomExecutorServiceFactory.NUM.decrementAndGet();
    }
}

