/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.net.impl.pool.ConnectionManager;
import io.vertx.core.net.impl.pool.Endpoint;
import io.vertx.core.net.impl.pool.EndpointProvider;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class ConnectionManagerTest
extends VertxTestBase {
    private static final Object TEST_KEY = new Object();

    @Test
    public void testGetConnectionSuccess() {
        this.testGetConnection(true);
    }

    @Test
    public void testGetConnectionFailure() {
        this.testGetConnection(false);
    }

    private void testGetConnection(final boolean success) {
        EventLoopContext ctx = (EventLoopContext)this.vertx.getOrCreateContext();
        final Connection result = new Connection();
        final Throwable failure = new Throwable();
        ConnectionManager mgr = new ConnectionManager((EndpointProvider)new EndpointProvider<Object, Connection>(){

            public Endpoint<Connection> create(Object key, ContextInternal ctx, Runnable dispose) {
                return new Endpoint<Connection>(dispose){

                    public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Connection>> handler) {
                        this.incRefCount();
                        if (success) {
                            handler.handle((Object)Future.succeededFuture((Object)result));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)failure));
                        }
                    }
                };
            }
        });
        mgr.getConnection((ContextInternal)ctx, TEST_KEY, ar -> {
            if (ar.succeeded()) {
                this.assertTrue(success);
                this.assertSame(result, ar.result());
            } else {
                this.assertFalse(success);
                this.assertSame(failure, ar.cause());
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDisposeAfterConnectionClose() {
        this.testDispose(true);
    }

    @Test
    public void testDisposeAfterCallback() {
        this.testDispose(false);
    }

    private void testDispose(final boolean closeConnectionAfterCallback) {
        EventLoopContext ctx = (EventLoopContext)this.vertx.getOrCreateContext();
        final Connection expected = new Connection();
        final boolean[] disposed = new boolean[1];
        ConnectionManager mgr = new ConnectionManager((EndpointProvider)new EndpointProvider<Object, Connection>(){

            public Endpoint<Connection> create(Object key, ContextInternal ctx, Runnable dispose) {
                return new Endpoint<Connection>(dispose){

                    public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Connection>> handler) {
                        this.incRefCount();
                        if (closeConnectionAfterCallback) {
                            handler.handle((Object)Future.succeededFuture((Object)expected));
                            ConnectionManagerTest.this.assertFalse(disposed[0]);
                            this.decRefCount();
                            ConnectionManagerTest.this.assertTrue(disposed[0]);
                        } else {
                            this.decRefCount();
                            ConnectionManagerTest.this.assertFalse(disposed[0]);
                            handler.handle((Object)Future.succeededFuture((Object)expected));
                            ConnectionManagerTest.this.assertTrue(disposed[0]);
                        }
                    }

                    protected void dispose() {
                        disposed[0] = true;
                    }
                };
            }
        });
        mgr.getConnection((ContextInternal)ctx, TEST_KEY, this.onSuccess(conn -> this.assertEquals(expected, conn)));
        ConnectionManagerTest.waitUntil(() -> disposed[0]);
    }

    @Test
    public void testCloseManager() throws Exception {
        EventLoopContext ctx = (EventLoopContext)this.vertx.getOrCreateContext();
        final Connection expected = new Connection();
        final boolean[] disposed = new boolean[1];
        ConnectionManager mgr = new ConnectionManager((EndpointProvider)new EndpointProvider<Object, Connection>(){

            public Endpoint<Connection> create(Object key, ContextInternal ctx, Runnable dispose) {
                return new Endpoint<Connection>(dispose){

                    public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Connection>> handler) {
                        this.incRefCount();
                        handler.handle((Object)Future.succeededFuture((Object)expected));
                    }

                    protected void dispose() {
                        disposed[0] = true;
                    }

                    protected void close() {
                        super.close();
                        this.decRefCount();
                    }
                };
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        mgr.getConnection((ContextInternal)ctx, TEST_KEY, this.onSuccess(conn -> {
            this.assertEquals(expected, conn);
            latch.countDown();
        }));
        this.awaitLatch(latch);
        this.assertFalse(disposed[0]);
        mgr.close();
        this.assertTrue(disposed[0]);
    }

    @Test
    public void testCloseManagerImmediately() {
        EventLoopContext ctx = (EventLoopContext)this.vertx.getOrCreateContext();
        Connection expected = new Connection();
        boolean[] disposed = new boolean[1];
        final AtomicReference adder = new AtomicReference();
        ConnectionManager mgr = new ConnectionManager((EndpointProvider)new EndpointProvider<Object, Connection>(){

            public Endpoint<Connection> create(Object key, ContextInternal ctx, Runnable dispose) {
                return new Endpoint<Connection>(dispose){

                    public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Connection>> handler) {
                        adder.set(() -> this.incRefCount());
                    }
                };
            }
        });
        mgr.getConnection((ContextInternal)ctx, TEST_KEY, this.onSuccess(conn -> {}));
        ConnectionManagerTest.waitUntil(() -> adder.get() != null);
        mgr.close();
        ((Runnable)adder.get()).run();
    }

    @Test
    public void testConcurrentDispose() throws Exception {
        int i;
        EventLoopContext ctx = (EventLoopContext)this.vertx.getOrCreateContext();
        final ConcurrentLinkedQueue<AtomicBoolean> disposals = new ConcurrentLinkedQueue<AtomicBoolean>();
        ConnectionManager mgr = new ConnectionManager((EndpointProvider)new EndpointProvider<Object, Connection>(){

            public Endpoint<Connection> create(Object key, ContextInternal ctx, Runnable dispose) {
                final AtomicBoolean disposed = new AtomicBoolean();
                disposals.add(disposed);
                return new Endpoint<Connection>(dispose){

                    public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Connection>> handler) {
                        if (disposed.get()) {
                            ConnectionManagerTest.this.fail();
                        } else {
                            Connection conn = new Connection();
                            this.incRefCount();
                            handler.handle((Object)Future.succeededFuture((Object)conn));
                            this.decRefCount();
                        }
                    }

                    protected void dispose() {
                        disposed.set(true);
                    }
                };
            }
        });
        int num = 100000;
        int concurrency = 4;
        CountDownLatch[] latches = new CountDownLatch[concurrency];
        for (i = 0; i < concurrency; ++i) {
            CountDownLatch cc;
            latches[i] = cc = new CountDownLatch(num);
            new Thread(() -> {
                for (int j = 0; j < num; ++j) {
                    mgr.getConnection((ContextInternal)ctx, TEST_KEY, this.onSuccess(conn -> cc.countDown()));
                }
            }).start();
        }
        for (i = 0; i < concurrency; ++i) {
            this.awaitLatch(latches[i]);
        }
        disposals.forEach(disposed -> ConnectionManagerTest.waitUntil(disposed::get));
    }

    static class Connection {
        Connection() {
        }
    }
}

