/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.pointer.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.core.json.pointer.JsonPointerIterator;
import io.vertx.core.json.pointer.impl.JsonPointerImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JsonPointerTest {
    @Test
    public void testParsing() {
        JsonPointer pointer = JsonPointer.from((String)"/hello/world");
        Assert.assertEquals((Object)"/hello/world", (Object)pointer.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingErrorWrongFirstElement() {
        JsonPointer.from((String)"bla/hello/world");
    }

    @Test
    public void testEncodingParsing() {
        JsonPointer pointer = JsonPointer.create().append("hell/o").append("worl~d");
        Assert.assertEquals((Object)"/hell~1o/worl~0d", (Object)pointer.toString());
    }

    @Test
    public void testURIParsing() {
        JsonPointer pointer = JsonPointer.fromURI((URI)URI.create("http://www.example.org#/hello/world"));
        Assert.assertEquals((Object)"/hello/world", (Object)pointer.toString());
        Assert.assertEquals((Object)URI.create("http://www.example.org#/hello/world"), (Object)pointer.toURI());
    }

    @Test
    public void testURIEncodedParsing() {
        JsonPointer pointer = JsonPointer.fromURI((URI)URI.create("http://www.example.org#/hello/world/%5Ea"));
        Assert.assertEquals((Object)"/hello/world/^a", (Object)pointer.toString());
        Assert.assertEquals((Object)URI.create("http://www.example.org#/hello/world/%5Ea"), (Object)pointer.toURI());
    }

    @Test
    public void testURIJsonPointerEncodedParsing() {
        JsonPointer pointer = JsonPointer.fromURI((URI)URI.create("http://www.example.org#/hell~1o/worl~0d"));
        Assert.assertEquals((Object)"/hell~1o/worl~0d", (Object)pointer.toString());
        Assert.assertEquals((Object)URI.create("http://www.example.org#/hell~1o/worl~0d"), (Object)pointer.toURI());
    }

    @Test
    public void testBuilding() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("hello");
        keys.add("world");
        JsonPointerImpl pointer = new JsonPointerImpl(URI.create("#"), keys);
        Assert.assertEquals((Object)"/hello/world", (Object)pointer.toString());
    }

    @Test
    public void testURIBuilding() {
        JsonPointer pointer = JsonPointer.create().append("hello").append("world");
        Assert.assertEquals((Object)URI.create("#/hello/world"), (Object)pointer.toURI());
    }

    @Test
    public void testEmptyBuilding() {
        JsonPointer pointer = JsonPointer.create();
        Assert.assertEquals((Object)"", (Object)pointer.toString());
        Assert.assertEquals((Object)URI.create("#"), (Object)pointer.toURI());
    }

    @Test
    public void testAppendOtherPointer() {
        JsonPointer firstPointer = JsonPointer.fromURI((URI)URI.create("http://example.com/stuff.json#/hello")).append("world");
        JsonPointer otherPointer = JsonPointer.fromURI((URI)URI.create("http://example.com/other.json#/francesco"));
        firstPointer.append(otherPointer);
        Assert.assertEquals((Object)URI.create("http://example.com/stuff.json#/hello/world/francesco"), (Object)firstPointer.toURI());
    }

    @Test
    public void testNullQuerying() {
        JsonPointer pointer = JsonPointer.from((String)"/hello/world");
        Assert.assertNull((Object)pointer.queryJson(null));
    }

    @Test
    public void testNullQueryingRootPointer() {
        JsonPointer pointer = JsonPointer.create();
        Assert.assertNull((Object)pointer.queryJson(null));
    }

    @Test
    public void testNullQueryingRootPointerDefault() {
        JsonPointer pointer = JsonPointer.create();
        Assert.assertEquals((Object)1, (Object)pointer.queryJsonOrDefault(null, (Object)1));
    }

    @Test
    public void testJsonObjectQuerying() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonPointer pointer = JsonPointer.from((String)"/hello/world");
        Assert.assertEquals((Object)1, (Object)pointer.queryJson((Object)obj));
    }

    @Test
    public void testJsonObjectQueryingDefaultValue() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonPointer pointer = JsonPointer.from((String)"/hello/world/my/friend");
        Assert.assertEquals((Object)1, (Object)pointer.queryJsonOrDefault((Object)obj, (Object)1));
    }

    @Test
    public void testJsonArrayQuerying() {
        JsonArray array = new JsonArray();
        array.add((Object)new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)2).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong")));
        array.add((Object)new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong")));
        Assert.assertEquals((Object)1, (Object)JsonPointer.from((String)"/1/hello/world").queryJson((Object)array));
        Assert.assertEquals((Object)1, (Object)JsonPointer.fromURI((URI)URI.create("#/1/hello/world")).queryJson((Object)array));
    }

    @Test
    public void testJsonArrayQueryingOrDefault() {
        JsonArray array = new JsonArray();
        array.add((Object)new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)2).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong")));
        array.add((Object)new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong")));
        Assert.assertEquals((Object)1, (Object)JsonPointer.from((String)"/5/hello/world").queryJsonOrDefault((Object)array, (Object)1));
    }

    @Test
    public void testRootPointer() {
        JsonPointer pointer = JsonPointer.create();
        JsonArray array = new JsonArray();
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)2).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        array.add((Object)obj);
        array.add((Object)new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong")));
        Assert.assertEquals((Object)array, (Object)pointer.queryJson((Object)array));
        Assert.assertEquals((Object)obj, (Object)pointer.queryJson((Object)obj));
        Assert.assertEquals((Object)"hello", (Object)pointer.queryJson((Object)"hello"));
    }

    @Test
    public void testRootPointerWrite() {
        JsonPointer pointer = JsonPointer.create();
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        Assert.assertSame((Object)arr, (Object)pointer.writeJson((Object)obj, (Object)arr, false));
    }

    @Test
    public void testWrongUsageOfDashForQuerying() {
        JsonArray array = new JsonArray();
        array.add((Object)new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)2).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong")));
        array.add((Object)new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong")));
        JsonPointer pointer = JsonPointer.from((String)"/-/hello/world");
        Assert.assertNull((Object)pointer.queryJson((Object)array));
    }

    @Test
    public void testRFCExample() {
        JsonObject obj = new JsonObject("   {\n      \"foo\": [\"bar\", \"baz\"],\n      \"\": 0,\n      \"a/b\": 1,\n      \"c%d\": 2,\n      \"e^f\": 3,\n      \"g|h\": 4,\n      \"i\\\\j\": 5,\n      \"k\\\"l\": 6,\n      \" \": 7,\n      \"m~n\": 8\n   }");
        Assert.assertEquals((Object)obj, (Object)JsonPointer.from((String)"").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getJsonArray("foo"), (Object)JsonPointer.from((String)"/foo").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getJsonArray("foo").getString(0), (Object)JsonPointer.from((String)"/foo/0").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger(""), (Object)JsonPointer.from((String)"/").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger("a/b"), (Object)JsonPointer.from((String)"/a~1b").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger("c%d"), (Object)JsonPointer.from((String)"/c%d").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger("e^f"), (Object)JsonPointer.from((String)"/e^f").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger("g|h"), (Object)JsonPointer.from((String)"/g|h").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger("i\\\\j"), (Object)JsonPointer.from((String)"/i\\\\j").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger("k\\\"l"), (Object)JsonPointer.from((String)"/k\\\"l").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger(" "), (Object)JsonPointer.from((String)"/ ").queryJson((Object)obj));
        Assert.assertEquals((Object)obj.getInteger("m~n"), (Object)JsonPointer.from((String)"/m~0n").queryJson((Object)obj));
    }

    @Test
    public void testWriteJsonObject() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonObject toInsert = new JsonObject().put("github", (Object)"slinkydeveloper");
        Assert.assertEquals((Object)obj, (Object)JsonPointer.from((String)"/hello/francesco").writeJson((Object)obj, (Object)toInsert));
        Assert.assertEquals((Object)toInsert, (Object)JsonPointer.from((String)"/hello/francesco").queryJson((Object)obj));
    }

    @Test
    public void testWriteWithCreateOnMissingJsonObject() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonObject toInsert = new JsonObject().put("github", (Object)"slinkydeveloper");
        Assert.assertEquals((Object)obj, (Object)JsonPointer.from((String)"/hello/users/francesco").write((Object)obj, JsonPointerIterator.JSON_ITERATOR, (Object)toInsert, true));
        Assert.assertEquals((Object)toInsert, (Object)JsonPointer.from((String)"/hello/users/francesco").queryJson((Object)obj));
    }

    @Test
    public void testWriteJsonObjectOverride() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonObject toInsert = new JsonObject().put("github", (Object)"slinkydeveloper");
        Assert.assertEquals((Object)obj, (Object)JsonPointer.from((String)"/hello/world").writeJson((Object)obj, (Object)toInsert));
        Assert.assertEquals((Object)toInsert, (Object)JsonPointer.from((String)"/hello/world").queryJson((Object)obj));
    }

    @Test
    public void testWriteJsonArray() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)new JsonObject()).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonArray array = new JsonArray();
        array.add((Object)obj.copy());
        array.add((Object)obj.copy());
        JsonObject toInsert = new JsonObject().put("github", (Object)"slinkydeveloper");
        Assert.assertEquals((Object)array, (Object)JsonPointer.from((String)"/0/hello/world/francesco").writeJson((Object)array, (Object)toInsert));
        Assert.assertEquals((Object)toInsert, (Object)JsonPointer.from((String)"/0/hello/world/francesco").queryJson((Object)array));
        Assert.assertNotEquals((Object)array.getValue(0), (Object)array.getValue(1));
    }

    @Test
    public void testWriteJsonArrayAppend() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonArray array = new JsonArray();
        array.add((Object)obj.copy());
        array.add((Object)obj.copy());
        JsonObject toInsert = new JsonObject().put("github", (Object)"slinkydeveloper");
        Assert.assertEquals((Object)array, (Object)JsonPointer.from((String)"/-").writeJson((Object)array, (Object)toInsert));
        Assert.assertEquals((Object)toInsert, (Object)JsonPointer.from((String)"/2").queryJson((Object)array));
        Assert.assertEquals((Object)array.getValue(0), (Object)array.getValue(1));
    }

    @Test
    public void testWriteJsonArraySubstitute() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonArray array = new JsonArray();
        array.add((Object)obj.copy());
        array.add((Object)obj.copy());
        JsonObject toInsert = new JsonObject().put("github", (Object)"slinkydeveloper");
        Assert.assertEquals((Object)array, (Object)JsonPointer.from((String)"/0").writeJson((Object)array, (Object)toInsert));
        Assert.assertEquals((Object)toInsert, (Object)JsonPointer.from((String)"/0").queryJson((Object)array));
        Assert.assertNotEquals((Object)array.getValue(0), (Object)array.getValue(1));
    }

    @Test
    public void testNestedWriteJsonArraySubstitute() {
        JsonObject obj = new JsonObject().put("hello", (Object)new JsonObject().put("world", (Object)1).put("worl", (Object)"wrong")).put("helo", (Object)new JsonObject().put("world", (Object)"wrong").put("worl", (Object)"wrong"));
        JsonArray array = new JsonArray();
        array.add((Object)obj.copy());
        array.add((Object)obj.copy());
        JsonObject root = new JsonObject().put("array", (Object)array);
        JsonObject toInsert = new JsonObject().put("github", (Object)"slinkydeveloper");
        Assert.assertEquals((Object)root, (Object)JsonPointer.from((String)"/array/0").writeJson((Object)root, (Object)toInsert));
        Assert.assertEquals((Object)toInsert, (Object)JsonPointer.from((String)"/array/0").queryJson((Object)root));
    }

    @Test
    public void testIsParent() {
        JsonPointer parent = JsonPointer.fromURI((URI)URI.create("yaml/valid/refs/Circular.yaml#/properties"));
        JsonPointer child = JsonPointer.fromURI((URI)URI.create("yaml/valid/refs/Circular.yaml#/properties/parent"));
        Assert.assertTrue((boolean)parent.isParent(child));
        Assert.assertFalse((boolean)child.isParent(parent));
    }

    @Test
    public void testIsParentDifferentURI() {
        JsonPointer parent = JsonPointer.fromURI((URI)URI.create("yaml/valid/refs/Circular.yaml#/properties"));
        JsonPointer child = JsonPointer.fromURI((URI)URI.create("json/valid/refs/Circular.yaml#/properties/parent"));
        Assert.assertFalse((boolean)parent.isParent(child));
        Assert.assertFalse((boolean)child.isParent(parent));
    }

    @Test
    public void testIsParentWithRootPointer() {
        JsonPointer parent = JsonPointer.fromURI((URI)URI.create("yaml/valid/refs/Circular.yaml#"));
        JsonPointer child = JsonPointer.fromURI((URI)URI.create("yaml/valid/refs/Circular.yaml#/properties/parent"));
        Assert.assertTrue((boolean)parent.isParent(child));
        Assert.assertFalse((boolean)child.isParent(parent));
    }

    @Test
    public void testTracedQuery() {
        JsonObject child2 = new JsonObject().put("child3", (Object)1);
        JsonArray child1 = new JsonArray().add((Object)child2);
        JsonObject root = new JsonObject().put("child1", (Object)child1);
        JsonPointer pointer = JsonPointer.create().append("child1").append("0").append("child3");
        List traced = pointer.tracedQuery((Object)root, JsonPointerIterator.JSON_ITERATOR);
        Assert.assertEquals((long)4L, (long)traced.size());
        Assert.assertSame((Object)root, traced.get(0));
        Assert.assertSame((Object)child1, traced.get(1));
        Assert.assertSame((Object)child2, traced.get(2));
        Assert.assertEquals((Object)1, traced.get(3));
    }

    @Test
    public void testEmptyTracedQuery() {
        JsonPointer pointer = JsonPointer.create().append("child1").append("0").append("child3");
        List traced = pointer.tracedQuery(null, JsonPointerIterator.JSON_ITERATOR);
        Assert.assertTrue((boolean)traced.isEmpty());
    }

    @Test
    public void testNotFoundTracedQuery() {
        JsonObject child2 = new JsonObject().put("child5", (Object)1);
        JsonArray child1 = new JsonArray().add((Object)child2);
        JsonObject root = new JsonObject().put("child1", (Object)child1);
        JsonPointer pointer = JsonPointer.create().append("child1").append("0").append("child3");
        List traced = pointer.tracedQuery((Object)root, JsonPointerIterator.JSON_ITERATOR);
        Assert.assertEquals((long)3L, (long)traced.size());
        Assert.assertSame((Object)root, traced.get(0));
        Assert.assertSame((Object)child1, traced.get(1));
        Assert.assertSame((Object)child2, traced.get(2));
    }
}

