/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.impl.Utils;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.test.core.TestUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JsonCodecTest {
    private static final TypeReference<Integer> INTEGER_TYPE_REF = new TypeReference<Integer>(){};
    private static final TypeReference<Long> LONG_TYPE_REF = new TypeReference<Long>(){};
    private static final TypeReference<String> STRING_TYPE_REF = new TypeReference<String>(){};
    private static final TypeReference<Float> FLOAT_TYPE_REF = new TypeReference<Float>(){};
    private static final TypeReference<Double> DOUBLE_TYPE_REF = new TypeReference<Double>(){};
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<Object>> LIST_TYPE_REF = new TypeReference<List<Object>>(){};
    private static final TypeReference<Boolean> BOOLEAN_TYPE_REF = new TypeReference<Boolean>(){};
    private final JacksonCodec mapper;

    @Parameterized.Parameters
    public static Collection<Object[]> mappers() {
        return Arrays.asList({new DatabindCodec()}, {new JacksonCodec()});
    }

    public JsonCodecTest(JacksonCodec mapper) {
        this.mapper = mapper;
    }

    @Test
    public void testEncodeJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("mystr", (Object)"foo");
        jsonObject.put("myint", (Object)123);
        jsonObject.put("mylong", (Object)1234L);
        jsonObject.put("myfloat", (Object)Float.valueOf(1.23f));
        jsonObject.put("mydouble", (Object)2.34);
        jsonObject.put("myboolean", (Object)true);
        jsonObject.put("mybyte", (Object)255);
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonObject.put("mybinary", (Object)bytes);
        jsonObject.put("mybuffer", (Object)Buffer.buffer((byte[])bytes));
        Instant now = Instant.now();
        jsonObject.put("myinstant", (Object)now);
        jsonObject.putNull("mynull");
        jsonObject.put("myobj", (Object)new JsonObject().put("foo", (Object)"bar"));
        jsonObject.put("myarr", (Object)new JsonArray().add((Object)"foo").add((Object)123));
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        String expected = "{\"mystr\":\"foo\",\"myint\":123,\"mylong\":1234,\"myfloat\":1.23,\"mydouble\":2.34,\"myboolean\":true,\"mybyte\":255,\"mybinary\":\"" + strBytes + "\",\"mybuffer\":\"" + strBytes + "\",\"myinstant\":\"" + DateTimeFormatter.ISO_INSTANT.format(now) + "\",\"mynull\":null,\"myobj\":{\"foo\":\"bar\"},\"myarr\":[\"foo\",123]}";
        String json = this.mapper.toString((Object)jsonObject);
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testEncodeJsonArray() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Object)"foo");
        jsonArray.add((Object)123);
        jsonArray.add((Object)1234L);
        jsonArray.add((Object)Float.valueOf(1.23f));
        jsonArray.add((Object)2.34);
        jsonArray.add((Object)true);
        jsonArray.add((Object)124);
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonArray.add((Object)bytes);
        jsonArray.add((Object)Buffer.buffer((byte[])bytes));
        jsonArray.addNull();
        jsonArray.add((Object)new JsonObject().put("foo", (Object)"bar"));
        jsonArray.add((Object)new JsonArray().add((Object)"foo").add((Object)123));
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        String expected = "[\"foo\",123,1234,1.23,2.34,true,124,\"" + strBytes + "\",\"" + strBytes + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]";
        String json = this.mapper.toString((Object)jsonArray);
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testEncodeJsonObjectToBuffer() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("mystr", (Object)"foo");
        jsonObject.put("myint", (Object)123);
        jsonObject.put("mylong", (Object)1234L);
        jsonObject.put("myfloat", (Object)Float.valueOf(1.23f));
        jsonObject.put("mydouble", (Object)2.34);
        jsonObject.put("myboolean", (Object)true);
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonObject.put("mybinary", (Object)bytes);
        jsonObject.put("mybuffer", (Object)Buffer.buffer((byte[])bytes));
        Instant now = Instant.now();
        jsonObject.put("myinstant", (Object)now);
        jsonObject.putNull("mynull");
        jsonObject.put("myobj", (Object)new JsonObject().put("foo", (Object)"bar"));
        jsonObject.put("myarr", (Object)new JsonArray().add((Object)"foo").add((Object)123));
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        Buffer expected = Buffer.buffer((String)("{\"mystr\":\"foo\",\"myint\":123,\"mylong\":1234,\"myfloat\":1.23,\"mydouble\":2.34,\"myboolean\":true,\"mybinary\":\"" + strBytes + "\",\"mybuffer\":\"" + strBytes + "\",\"myinstant\":\"" + DateTimeFormatter.ISO_INSTANT.format(now) + "\",\"mynull\":null,\"myobj\":{\"foo\":\"bar\"},\"myarr\":[\"foo\",123]}"), (String)"UTF-8");
        Buffer json = this.mapper.toBuffer((Object)jsonObject);
        Assert.assertArrayEquals((byte[])expected.getBytes(), (byte[])json.getBytes());
    }

    @Test
    public void testEncodeJsonArrayToBuffer() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Object)"foo");
        jsonArray.add((Object)123);
        jsonArray.add((Object)1234L);
        jsonArray.add((Object)Float.valueOf(1.23f));
        jsonArray.add((Object)2.34);
        jsonArray.add((Object)true);
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonArray.add((Object)bytes);
        jsonArray.add((Object)Buffer.buffer((byte[])bytes));
        jsonArray.addNull();
        jsonArray.add((Object)new JsonObject().put("foo", (Object)"bar"));
        jsonArray.add((Object)new JsonArray().add((Object)"foo").add((Object)123));
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        Buffer expected = Buffer.buffer((String)("[\"foo\",123,1234,1.23,2.34,true,\"" + strBytes + "\",\"" + strBytes + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]"), (String)"UTF-8");
        Buffer json = this.mapper.toBuffer((Object)jsonArray);
        Assert.assertArrayEquals((byte[])expected.getBytes(), (byte[])json.getBytes());
    }

    @Test
    public void testEncodeJsonObjectPrettily() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("mystr", (Object)"foo");
        jsonObject.put("myint", (Object)123);
        jsonObject.put("mylong", (Object)1234L);
        jsonObject.put("myfloat", (Object)Float.valueOf(1.23f));
        jsonObject.put("mydouble", (Object)2.34);
        jsonObject.put("myboolean", (Object)true);
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonObject.put("mybinary", (Object)bytes);
        jsonObject.put("mybuffer", (Object)Buffer.buffer((byte[])bytes));
        Instant now = Instant.now();
        jsonObject.put("myinstant", (Object)now);
        jsonObject.put("myobj", (Object)new JsonObject().put("foo", (Object)"bar"));
        jsonObject.put("myarr", (Object)new JsonArray().add((Object)"foo").add((Object)123));
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        String strInstant = DateTimeFormatter.ISO_INSTANT.format(now);
        String expected = "{" + Utils.LINE_SEPARATOR + "  \"mystr\" : \"foo\"," + Utils.LINE_SEPARATOR + "  \"myint\" : 123," + Utils.LINE_SEPARATOR + "  \"mylong\" : 1234," + Utils.LINE_SEPARATOR + "  \"myfloat\" : 1.23," + Utils.LINE_SEPARATOR + "  \"mydouble\" : 2.34," + Utils.LINE_SEPARATOR + "  \"myboolean\" : true," + Utils.LINE_SEPARATOR + "  \"mybinary\" : \"" + strBytes + "\"," + Utils.LINE_SEPARATOR + "  \"mybuffer\" : \"" + strBytes + "\"," + Utils.LINE_SEPARATOR + "  \"myinstant\" : \"" + strInstant + "\"," + Utils.LINE_SEPARATOR + "  \"myobj\" : {" + Utils.LINE_SEPARATOR + "    \"foo\" : \"bar\"" + Utils.LINE_SEPARATOR + "  }," + Utils.LINE_SEPARATOR + "  \"myarr\" : [ \"foo\", 123 ]" + Utils.LINE_SEPARATOR + "}";
        String json = this.mapper.toString((Object)jsonObject, true);
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testEncodeJsonArrayPrettily() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Object)"foo");
        jsonArray.add((Object)123);
        jsonArray.add((Object)1234L);
        jsonArray.add((Object)Float.valueOf(1.23f));
        jsonArray.add((Object)2.34);
        jsonArray.add((Object)true);
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonArray.add((Object)bytes);
        jsonArray.add((Object)Buffer.buffer((byte[])bytes));
        jsonArray.addNull();
        jsonArray.add((Object)new JsonObject().put("foo", (Object)"bar"));
        jsonArray.add((Object)new JsonArray().add((Object)"foo").add((Object)123));
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        String expected = "[ \"foo\", 123, 1234, 1.23, 2.34, true, \"" + strBytes + "\", \"" + strBytes + "\", null, {" + Utils.LINE_SEPARATOR + "  \"foo\" : \"bar\"" + Utils.LINE_SEPARATOR + "}, [ \"foo\", 123 ] ]";
        String json = this.mapper.toString((Object)jsonArray, true);
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testDecodeJsonObject() {
        byte[] bytes = TestUtils.randomByteArray(10);
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        Instant now = Instant.now();
        String strInstant = DateTimeFormatter.ISO_INSTANT.format(now);
        String json = "{\"mystr\":\"foo\",\"myint\":123,\"mylong\":1234,\"myfloat\":1.23,\"mydouble\":2.34,\"myboolean\":true,\"mybyte\":124,\"mybinary\":\"" + strBytes + "\",\"mybuffer\":\"" + strBytes + "\",\"myinstant\":\"" + strInstant + "\",\"mynull\":null,\"myobj\":{\"foo\":\"bar\"},\"myarr\":[\"foo\",123]}";
        JsonObject obj = new JsonObject((Map)this.mapper.fromString(json, Map.class));
        Assert.assertEquals((Object)json, (Object)this.mapper.toString((Object)obj));
        Assert.assertEquals((Object)"foo", (Object)obj.getString("mystr"));
        Assert.assertEquals((Object)123, (Object)obj.getInteger("myint"));
        Assert.assertEquals((Object)1234L, (Object)obj.getLong("mylong"));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)obj.getFloat("myfloat"));
        Assert.assertEquals((Object)2.34, (Object)obj.getDouble("mydouble"));
        Assert.assertTrue((boolean)obj.getBoolean("myboolean"));
        Assert.assertEquals((Object)124, (Object)obj.getValue("mybyte"));
        Assert.assertArrayEquals((byte[])bytes, (byte[])obj.getBinary("mybinary"));
        Assert.assertEquals((Object)Buffer.buffer((byte[])bytes), (Object)obj.getBuffer("mybuffer"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)obj.getValue("mybinary"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)obj.getValue("mybuffer"));
        Assert.assertEquals((Object)now, (Object)obj.getInstant("myinstant"));
        Assert.assertEquals((Object)now.toString(), (Object)obj.getValue("myinstant"));
        Assert.assertTrue((boolean)obj.containsKey("mynull"));
        JsonObject nestedObj = obj.getJsonObject("myobj");
        Assert.assertEquals((Object)"bar", (Object)nestedObj.getString("foo"));
        JsonArray nestedArr = obj.getJsonArray("myarr");
        Assert.assertEquals((Object)"foo", (Object)nestedArr.getString(0));
        Assert.assertEquals((Object)123, (Object)nestedArr.getInteger(1));
    }

    @Test
    public void testDecodeJsonArray() {
        byte[] bytes = TestUtils.randomByteArray(10);
        String strBytes = JsonUtil.BASE64_ENCODER.encodeToString(bytes);
        Instant now = Instant.now();
        String strInstant = DateTimeFormatter.ISO_INSTANT.format(now);
        String json = "[\"foo\",123,1234,1.23,2.34,true,124,\"" + strBytes + "\",\"" + strBytes + "\",\"" + strInstant + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]";
        JsonArray arr = new JsonArray((List)this.mapper.fromString(json, List.class));
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertEquals((Object)1234L, (Object)arr.getLong(2));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)arr.getFloat(3));
        Assert.assertEquals((Object)2.34, (Object)arr.getDouble(4));
        Assert.assertEquals((Object)true, (Object)arr.getBoolean(5));
        Assert.assertEquals((Object)124, (Object)arr.getValue(6));
        Assert.assertArrayEquals((byte[])bytes, (byte[])arr.getBinary(7));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)arr.getValue(7));
        Assert.assertEquals((Object)Buffer.buffer((byte[])bytes), (Object)arr.getBuffer(8));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)arr.getValue(8));
        Assert.assertEquals((Object)now, (Object)arr.getInstant(9));
        Assert.assertEquals((Object)now.toString(), (Object)arr.getValue(9));
        Assert.assertTrue((boolean)arr.hasNull(10));
        JsonObject obj = arr.getJsonObject(11);
        Assert.assertEquals((Object)"bar", (Object)obj.getString("foo"));
        JsonArray arr2 = arr.getJsonArray(12);
        Assert.assertEquals((Object)"foo", (Object)arr2.getString(0));
        Assert.assertEquals((Object)123, (Object)arr2.getInteger(1));
    }

    @Test
    public void testDecodeJsonObjectWithComments() {
        String jsonWithComments = "// single line comment\n/*\n  This is a multi \n  line comment\n*/\n{\n// another single line comment this time inside the JSON object itself\n  \"foo\": \"bar\" // and a single line comment at end of line \n/*\n  This is a another multi \n  line comment this time inside the JSON object itself\n*/\n}";
        JsonObject json = new JsonObject((Map)this.mapper.fromString(jsonWithComments, Map.class));
        Assert.assertEquals((Object)"{\"foo\":\"bar\"}", (Object)this.mapper.toString((Object)json));
    }

    @Test
    public void testDecodeJsonArrayWithComments() {
        String jsonWithComments = "// single line comment\n/*\n  This is a multi \n  line comment\n*/\n[\n// another single line comment this time inside the JSON array itself\n  \"foo\", \"bar\" // and a single line comment at end of line \n/*\n  This is a another multi \n  line comment this time inside the JSON array itself\n*/\n]";
        JsonArray json = new JsonArray((List)this.mapper.fromString(jsonWithComments, List.class));
        Assert.assertEquals((Object)"[\"foo\",\"bar\"]", (Object)this.mapper.toString((Object)json));
    }

    @Test
    public void testDecodeJsonObjectWithInvalidJson() {
        for (String test : new String[]{"3", "\"3", "qiwjdoiqwjdiqwjd", "{\"foo\":1},{\"bar\":2}", "{\"foo\":1} 1234"}) {
            try {
                this.mapper.fromString(test, Map.class);
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
            try {
                this.mapper.fromBuffer(Buffer.buffer((String)test), Map.class);
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDecodeJsonArrayWithInvalidJson() {
        for (String test : new String[]{"3", "\"3", "qiwjdoiqwjdiqwjd", "[1],[2]", "[] 1234"}) {
            try {
                this.mapper.fromString(test, List.class);
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
            try {
                this.mapper.fromBuffer(Buffer.buffer((String)test), List.class);
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void encodeCustomTypeInstant() {
        Instant now = Instant.now();
        String json = this.mapper.toString((Object)now);
        Assert.assertNotNull((Object)json);
        Instant decoded = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(json.substring(1, json.length() - 1)));
        Assert.assertEquals((Object)now, (Object)decoded);
    }

    @Test
    public void decodeCustomTypeInstant() {
        Instant now = Instant.now();
        String json = '\"' + DateTimeFormatter.ISO_INSTANT.format(now) + '\"';
        Instant decoded = (Instant)this.mapper.fromString(json, Instant.class);
        Assert.assertEquals((Object)now, (Object)decoded);
    }

    @Test
    public void encodeCustomTypeBinary() {
        byte[] data = new byte[]{104, 101, 108, 108, 111};
        String json = this.mapper.toString((Object)data);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"\"aGVsbG8\"", (Object)json);
        json = this.mapper.toString((Object)Buffer.buffer((byte[])data));
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"\"aGVsbG8\"", (Object)json);
    }

    @Test
    public void decodeCustomTypeBinary() {
        byte[] data = (byte[])this.mapper.fromString("\"aGVsbG8\"", byte[].class);
        Assert.assertEquals((Object)"hello", (Object)new String(data));
        Buffer buff = (Buffer)this.mapper.fromString("\"aGVsbG8\"", Buffer.class);
        Assert.assertEquals((Object)"hello", (Object)buff.toString());
    }

    @Test
    public void encodeNull() {
        String json = this.mapper.toString(null);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"null", (Object)json);
    }

    @Test
    public void encodeToBuffer() {
        Buffer json = this.mapper.toBuffer((Object)"Hello World!");
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"\"Hello World!\"", (Object)json.toString());
    }

    @Test
    public void encodeNullToBuffer() {
        Buffer json = this.mapper.toBuffer(null);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"null", (Object)json.toString());
    }

    @Test
    public void testDecodeValue() {
        this.assertDecodeValue(Buffer.buffer((String)"42"), 42, INTEGER_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"42"), 42L, LONG_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"\"foobar\""), "foobar", STRING_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"3.4"), Float.valueOf(3.4f), FLOAT_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"3.4"), 3.4, DOUBLE_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"{\"foo\":4}"), Collections.singletonMap("foo", 4), MAP_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"[0,1,2]"), Arrays.asList(0, 1, 2), LIST_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"true"), true, BOOLEAN_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"false"), false, BOOLEAN_TYPE_REF);
    }

    @Test
    public void testEnumValue() {
        Buffer json = this.mapper.toBuffer((Object)WebsocketVersion.V13);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"\"V13\"", (Object)json.toString());
        this.mapper.fromBuffer(json, WebsocketVersion.class);
    }

    @Test
    public void testBigNumberValues() {
        Buffer json = this.mapper.toBuffer((Object)new BigDecimal("124567890124567890.09876543210987654321"));
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"124567890124567890.09876543210987654321", (Object)json.toString());
        Buffer json2 = this.mapper.toBuffer((Object)new BigInteger("12456789009876543211245678900987654321"));
        Assert.assertNotNull((Object)json2);
        Assert.assertEquals((Object)"12456789009876543211245678900987654321", (Object)json2.toString());
    }

    private <T> void assertDecodeValue(Buffer buffer, T expected, TypeReference<T> ref) {
        Type type = ref.getType();
        Class clazz = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
        Assert.assertEquals(expected, (Object)this.mapper.fromBuffer(buffer, clazz));
        Assert.assertEquals(expected, (Object)this.mapper.fromBuffer(buffer, ref));
        Assert.assertEquals(expected, (Object)this.mapper.fromString(buffer.toString(StandardCharsets.UTF_8), clazz));
        Assert.assertEquals(expected, (Object)this.mapper.fromString(buffer.toString(StandardCharsets.UTF_8), ref));
        Buffer nullValue = Buffer.buffer((String)"null");
        Assert.assertNull((Object)this.mapper.fromBuffer(nullValue, clazz));
        Assert.assertNull((Object)this.mapper.fromBuffer(nullValue, ref));
        Assert.assertNull((Object)this.mapper.fromString(nullValue.toString(StandardCharsets.UTF_8), clazz));
        Assert.assertNull((Object)this.mapper.fromString(nullValue.toString(StandardCharsets.UTF_8), ref));
    }

    @Test
    public void testDecodeBufferUnknowContent() {
        this.testDecodeUnknowContent(true);
    }

    @Test
    public void testDecodeStringUnknowContent() {
        this.testDecodeUnknowContent(false);
    }

    private void testDecodeUnknowContent(boolean asBuffer) {
        String number = String.valueOf(1);
        Assert.assertEquals((Object)1, (Object)(asBuffer ? this.mapper.fromBuffer(Buffer.buffer((String)number)) : this.mapper.fromString(number)));
        String bool = Boolean.TRUE.toString();
        Assert.assertEquals((Object)true, (Object)(asBuffer ? this.mapper.fromBuffer(Buffer.buffer((String)bool)) : this.mapper.fromString(bool)));
        String text = "\"whatever\"";
        Assert.assertEquals((Object)"whatever", (Object)(asBuffer ? this.mapper.fromBuffer(Buffer.buffer((String)text)) : this.mapper.fromString(text)));
        String nullText = "null";
        Assert.assertNull((Object)(asBuffer ? this.mapper.fromBuffer(Buffer.buffer((String)nullText)) : this.mapper.fromString(nullText)));
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        Assert.assertEquals((Object)obj, (Object)(asBuffer ? this.mapper.fromBuffer(obj.toBuffer()) : this.mapper.fromString(obj.toString())));
        JsonArray arr = new JsonArray().add((Object)1).add((Object)false).add((Object)"whatever").add((Object)obj);
        Assert.assertEquals((Object)arr, (Object)(asBuffer ? this.mapper.fromBuffer(arr.toBuffer()) : this.mapper.fromString(arr.toString())));
        String invalidText = "\"invalid";
        try {
            if (asBuffer) {
                this.mapper.fromBuffer(Buffer.buffer((String)invalidText));
            } else {
                this.mapper.fromString(invalidText);
            }
            Assert.fail();
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
    }

    @Test
    public void testEncodeCollectionState() {
        Assert.assertEquals((Object)"{\"key\":\"QQ\"}", (Object)this.checkMap(new byte[]{65}));
        Assert.assertEquals((Object)"[\"QQ\"]", (Object)this.checkList(new byte[]{65}));
        Assert.assertEquals((Object)"{\"key\":\"QQ\"}", (Object)this.checkMap(Buffer.buffer((String)"A")));
        Assert.assertEquals((Object)"[\"QQ\"]", (Object)this.checkList(Buffer.buffer((String)"A")));
        Instant instant = Instant.ofEpochMilli(0L);
        Assert.assertEquals((Object)"{\"key\":\"1970-01-01T00:00:00Z\"}", (Object)this.checkMap(instant));
        Assert.assertEquals((Object)"[\"1970-01-01T00:00:00Z\"]", (Object)this.checkList(instant));
        Assert.assertEquals((Object)"{\"key\":\"MICROSECONDS\"}", (Object)this.checkMap((Object)TimeUnit.MICROSECONDS));
        Assert.assertEquals((Object)"[\"MICROSECONDS\"]", (Object)this.checkList((Object)TimeUnit.MICROSECONDS));
        BigInteger bigInt = new BigInteger("123456789");
        Assert.assertEquals((Object)"{\"key\":123456789}", (Object)this.checkMap(bigInt));
        Assert.assertEquals((Object)"[123456789]", (Object)this.checkList(bigInt));
        BigDecimal bigDec = new BigDecimal(bigInt).divide(new BigDecimal("100"));
        Assert.assertEquals((Object)"{\"key\":1234567.89}", (Object)this.checkMap(bigDec));
        Assert.assertEquals((Object)"[1234567.89]", (Object)this.checkList(bigDec));
        Assert.assertEquals((Object)"{\"key\":{\"foo\":\"bar\"}}", (Object)this.checkMap(new JsonObject().put("foo", (Object)"bar")));
        Assert.assertEquals((Object)"[{\"foo\":\"bar\"}]", (Object)this.checkList(new JsonObject().put("foo", (Object)"bar")));
        Assert.assertEquals((Object)"{\"key\":[\"foo\"]}", (Object)this.checkMap(new JsonArray().add((Object)"foo")));
        Assert.assertEquals((Object)"[[\"foo\"]]", (Object)this.checkList(new JsonArray().add((Object)"foo")));
        Locale locale = Locale.FRANCE;
        if (this.mapper instanceof DatabindCodec) {
            Assert.assertEquals((Object)"{\"key\":\"fr_FR\"}", (Object)this.checkMap(locale));
            Assert.assertEquals((Object)"[\"fr_FR\"]", (Object)this.checkList(locale));
        } else {
            CharSequence cs = HttpHeaders.ACCEPT;
            Assert.assertFalse((boolean)(cs instanceof String));
            try {
                this.checkMap(cs);
                Assert.fail();
            }
            catch (EncodeException encodeException) {
                // empty catch block
            }
            try {
                this.checkList(cs);
                Assert.fail();
            }
            catch (EncodeException encodeException) {
                // empty catch block
            }
            try {
                this.checkMap(locale);
                Assert.fail();
            }
            catch (EncodeException encodeException) {
                // empty catch block
            }
            try {
                this.checkList(locale);
                Assert.fail();
            }
            catch (EncodeException encodeException) {
                // empty catch block
            }
        }
    }

    private String checkMap(Object o) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", o);
        return this.mapper.toString(map, false);
    }

    private String checkList(Object o) {
        return this.mapper.toString(Collections.singletonList(o), false);
    }
}

