/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Promise;
import io.vertx.core.VertxTest;
import io.vertx.core.impl.CloseFuture;
import io.vertx.test.core.AsyncTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class CloseFutureTest
extends AsyncTestBase {
    @Test
    public void testHookCompletion() {
        CloseFuture cf = new CloseFuture();
        AtomicReference ref = new AtomicReference();
        cf.add(completion -> ref.set(completion));
        this.assertFalse(cf.close().succeeded());
        this.assertNotNull(ref.get());
        ((Promise)ref.get()).complete();
        this.assertTrue(cf.close().succeeded());
    }

    @Test
    public void testRemoveDisposedCloseFutureHook() {
        CloseFuture cf = new CloseFuture();
        CloseFuture hook = new CloseFuture();
        cf.add((Closeable)hook);
        this.assertTrue(hook.close().succeeded());
        cf.close();
        this.assertFalse(cf.remove((Closeable)hook));
    }

    @Test
    public void testCloseFutureDuplicateClose() {
        AtomicReference ref = new AtomicReference();
        CloseFuture fut = new CloseFuture();
        fut.add(ref::set);
        Promise p1 = Promise.promise();
        fut.close(p1);
        this.assertNotNull(ref.get());
        Promise p2 = Promise.promise();
        fut.close(p2);
        this.assertFalse(p1.future().isComplete());
        this.assertFalse(p2.future().isComplete());
        ((Promise)ref.get()).complete();
        this.assertTrue(p1.future().isComplete());
        this.assertTrue(p2.future().isComplete());
    }

    @Test
    public void testFinalize() {
        CloseFuture cf = new CloseFuture();
        CloseFuture hook = new CloseFuture();
        AtomicInteger closed = new AtomicInteger();
        hook.add(completion -> {
            closed.incrementAndGet();
            completion.complete();
        });
        cf.add((Closeable)hook);
        hook = null;
        VertxTest.runGC();
        this.assertTrue(cf.close().succeeded());
    }

    @Test
    public void testCloseHook() {
        CloseFuture cf = new CloseFuture();
        CloseFuture hook = new CloseFuture();
        cf.add((Closeable)hook);
        hook.close();
        this.assertFalse(cf.remove((Closeable)hook));
        this.assertTrue(cf.close().succeeded());
    }
}

