/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.http.impl.CookieImpl;
import io.vertx.core.http.impl.CookieJar;
import io.vertx.core.http.impl.ServerCookie;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class CookieJarTest {
    @Test
    public void testInsert() {
        CookieJar jar = new CookieJar();
        Assert.assertEquals((long)0L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar"));
        Assert.assertEquals((long)1L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setDomain("vertx.io"));
        Assert.assertEquals((long)2L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setDomain("vertx.io").setPath("/secret"));
        Assert.assertEquals((long)3L, (long)jar.size());
    }

    @Test
    public void testReplace() {
        CookieJar jar = new CookieJar();
        Assert.assertEquals((long)0L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar"));
        Assert.assertEquals((long)1L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "barista"));
        Assert.assertEquals((long)1L, (long)jar.size());
        for (ServerCookie cookie : jar) {
            Assert.assertEquals((Object)"barista", (Object)cookie.getValue());
        }
    }

    @Test
    public void testSameName() {
        CookieJar jar = new CookieJar();
        Assert.assertEquals((long)0L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar"));
        Assert.assertEquals((long)1L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setDomain("a"));
        Assert.assertEquals((long)2L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setDomain("b"));
        Assert.assertEquals((long)3L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setPath("a"));
        Assert.assertEquals((long)4L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setPath("b"));
        Assert.assertEquals((long)5L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setPath("a").setDomain("a"));
        Assert.assertEquals((long)6L, (long)jar.size());
        jar.add((ServerCookie)new CookieImpl("foo", "bar").setPath("b").setDomain("b"));
        Assert.assertEquals((long)7L, (long)jar.size());
    }

    @Test
    public void testFilterByName() {
        CookieJar jar = new CookieJar();
        jar.add((ServerCookie)new CookieImpl("a", "a"));
        jar.add((ServerCookie)new CookieImpl("a", "a").setPath("p"));
        jar.add((ServerCookie)new CookieImpl("b", "b"));
        CookieJar subJar = jar.getAll("a");
        Assert.assertEquals((long)2L, (long)subJar.size());
    }

    @Test
    public void testFilterByUniqueId() {
        CookieJar jar = new CookieJar();
        jar.add((ServerCookie)new CookieImpl("a", "a"));
        jar.add((ServerCookie)new CookieImpl("a", "a").setPath("p"));
        jar.add((ServerCookie)new CookieImpl("b", "b"));
        ServerCookie cookie = jar.get("a", null, "p");
        Assert.assertNotNull((Object)cookie);
    }

    @Test
    public void testRemoveFromIterator() {
        CookieJar jar = new CookieJar();
        jar.add((ServerCookie)new CookieImpl("a", "a"));
        jar.add((ServerCookie)new CookieImpl("a", "a").setPath("p"));
        jar.add((ServerCookie)new CookieImpl("b", "b"));
        Iterator it = jar.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        it.remove();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveFromIteratorSubJar() {
        CookieJar jar = new CookieJar();
        jar.add((ServerCookie)new CookieImpl("a", "a"));
        jar.add((ServerCookie)new CookieImpl("a", "a").setPath("p"));
        jar.add((ServerCookie)new CookieImpl("b", "b"));
        CookieJar subJar = jar.getAll("a");
        Iterator it = subJar.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        it.remove();
    }

    @Test
    public void testPropertyPropagation() {
        CookieJar jar = new CookieJar();
        jar.add((ServerCookie)new CookieImpl("a", "a"));
        for (ServerCookie cookie : jar.getAll("a")) {
            cookie.setValue("b");
        }
        Assert.assertEquals((Object)"b", (Object)jar.get("a").getValue());
    }
}

