/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Http2TestBase
extends HttpTestBase {
    protected HttpServerOptions serverOptions;
    protected HttpClientOptions clientOptions;
    protected List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>();

    public static HttpServerOptions createHttp2ServerOptions(int port, String host) {
        return new HttpServerOptions().setPort(port).setHost(host).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()).setUseAlpn(true).setSsl(true).addEnabledCipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA").setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get());
    }

    public static HttpClientOptions createHttp2ClientOptions() {
        return new HttpClientOptions().setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()).setUseAlpn(true).setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()).setProtocolVersion(HttpVersion.HTTP_2);
    }

    @Override
    public void setUp() throws Exception {
        this.eventLoopGroups.clear();
        this.serverOptions = Http2TestBase.createHttp2ServerOptions(4043, "localhost");
        this.clientOptions = Http2TestBase.createHttp2ClientOptions();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        for (EventLoopGroup eventLoopGroup : this.eventLoopGroups) {
            eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return this.serverOptions;
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return this.clientOptions;
    }
}

