/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.test.core.TestUtils;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class Http2SettingsTest {
    long[] min = new long[]{0L, 0L, 0L, 0L, 16384L, 0L};
    long[] max = new long[]{0xFFFFFFFFL, 1L, 0xFFFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFL, Integer.MAX_VALUE};

    @Test
    public void testSettingsMin() {
        for (int i = 1; i <= 6; ++i) {
            try {
                new Http2Settings().set(i, this.min[i - 1] - 1L);
                Assert.fail();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Http2Settings settings = new Http2Settings();
        for (int i = 1; i <= 6; ++i) {
            settings.set(i, this.min[i - 1]);
        }
        HttpUtils.fromVertxSettings((Http2Settings)settings);
    }

    @Test
    public void testSettinsMax() {
        for (int i = 1; i <= 6; ++i) {
            try {
                new Http2Settings().set(i, this.max[i - 1] + 1L);
                Assert.fail((String)("Was expecting setting " + (i - 1) + " update to throw IllegalArgumentException"));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Http2Settings settings = new Http2Settings();
        for (int i = 1; i <= 6; ++i) {
            settings.set(i, this.max[i - 1]);
        }
        HttpUtils.fromVertxSettings((Http2Settings)settings);
    }

    @Test
    public void toNettySettings() {
        int i;
        Http2Settings settings = new Http2Settings();
        for (int i2 = 7; i2 <= 65535; ++i2) {
            settings.set(65535, Math.min(0xFFFFFFFFL, TestUtils.randomPositiveLong()));
        }
        io.netty.handler.codec.http2.Http2Settings conv = HttpUtils.fromVertxSettings((Http2Settings)settings);
        for (i = 1; i <= 65535; ++i) {
            Assert.assertEquals((Object)settings.get(i), (Object)conv.get((char)i));
        }
        settings = HttpUtils.toVertxSettings((io.netty.handler.codec.http2.Http2Settings)conv);
        for (i = 1; i <= 65535; ++i) {
            Assert.assertEquals((Object)settings.get(i), (Object)conv.get((char)i));
        }
    }

    @Test
    public void testSettings() {
        Http2Settings settings = new Http2Settings();
        Assert.assertEquals((Object)true, (Object)settings.isPushEnabled());
        Assert.assertEquals((long)8192L, (long)settings.getMaxHeaderListSize());
        Assert.assertEquals((long)0xFFFFFFFFL, (long)settings.getMaxConcurrentStreams());
        Assert.assertEquals((long)65535L, (long)settings.getInitialWindowSize());
        Assert.assertEquals((long)16384L, (long)settings.getMaxFrameSize());
        Assert.assertEquals(null, (Object)settings.getExtraSettings());
        Http2Settings update = TestUtils.randomHttp2Settings();
        Assert.assertFalse((boolean)settings.equals((Object)update));
        Assert.assertNotSame((Object)settings.hashCode(), (Object)settings.hashCode());
        Assert.assertSame((Object)settings, (Object)settings.setHeaderTableSize(update.getHeaderTableSize()));
        Assert.assertEquals((long)settings.getHeaderTableSize(), (long)update.getHeaderTableSize());
        Assert.assertSame((Object)settings, (Object)settings.setPushEnabled(update.isPushEnabled()));
        Assert.assertEquals((Object)settings.isPushEnabled(), (Object)update.isPushEnabled());
        Assert.assertSame((Object)settings, (Object)settings.setMaxHeaderListSize(update.getMaxHeaderListSize()));
        Assert.assertEquals((long)settings.getMaxHeaderListSize(), (long)update.getMaxHeaderListSize());
        Assert.assertSame((Object)settings, (Object)settings.setMaxConcurrentStreams(update.getMaxConcurrentStreams()));
        Assert.assertEquals((long)settings.getMaxConcurrentStreams(), (long)update.getMaxConcurrentStreams());
        Assert.assertSame((Object)settings, (Object)settings.setInitialWindowSize(update.getInitialWindowSize()));
        Assert.assertEquals((long)settings.getInitialWindowSize(), (long)update.getInitialWindowSize());
        Assert.assertSame((Object)settings, (Object)settings.setMaxFrameSize(update.getMaxFrameSize()));
        Assert.assertEquals((long)settings.getMaxFrameSize(), (long)update.getMaxFrameSize());
        Assert.assertSame((Object)settings, (Object)settings.setExtraSettings(update.getExtraSettings()));
        HashMap extraSettings = new HashMap(update.getExtraSettings());
        Assert.assertEquals((Object)update.getExtraSettings(), extraSettings);
        extraSettings.clear();
        Assert.assertEquals((Object)update.getExtraSettings(), (Object)settings.getExtraSettings());
        Assert.assertTrue((boolean)settings.equals((Object)update));
        Assert.assertEquals((long)settings.hashCode(), (long)settings.hashCode());
        settings = new Http2Settings(update);
        Assert.assertEquals((long)settings.getHeaderTableSize(), (long)update.getHeaderTableSize());
        Assert.assertEquals((Object)settings.isPushEnabled(), (Object)update.isPushEnabled());
        Assert.assertEquals((long)settings.getMaxHeaderListSize(), (long)update.getMaxHeaderListSize());
        Assert.assertEquals((long)settings.getMaxConcurrentStreams(), (long)update.getMaxConcurrentStreams());
        Assert.assertEquals((long)settings.getInitialWindowSize(), (long)update.getInitialWindowSize());
        Assert.assertEquals((long)settings.getMaxFrameSize(), (long)update.getMaxFrameSize());
        Assert.assertEquals((Object)update.getExtraSettings(), (Object)settings.getExtraSettings());
    }

    @Test
    public void testEqualsHashCode() throws Exception {
        Http2Settings s1 = new Http2Settings().setHeaderTableSize(1024L);
        Http2Settings s2 = new Http2Settings().setHeaderTableSize(1024L);
        Http2Settings s3 = new Http2Settings(s1.toJson());
        Http2Settings s4 = new Http2Settings().setHeaderTableSize(2048L);
        Assert.assertEquals((Object)s1, (Object)s1);
        Assert.assertEquals((Object)s2, (Object)s2);
        Assert.assertEquals((Object)s3, (Object)s3);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((Object)s2, (Object)s1);
        Assert.assertEquals((Object)s2, (Object)s3);
        Assert.assertEquals((Object)s3, (Object)s2);
        Assert.assertEquals((Object)s1, (Object)s3);
        Assert.assertEquals((Object)s3, (Object)s1);
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertEquals((long)s2.hashCode(), (long)s3.hashCode());
        Assert.assertFalse((boolean)s1.equals(null));
        Assert.assertFalse((boolean)s2.equals(null));
        Assert.assertFalse((boolean)s3.equals(null));
        Assert.assertNotEquals((Object)s1, (Object)s4);
        Assert.assertNotEquals((Object)s4, (Object)s1);
        Assert.assertNotEquals((Object)s2, (Object)s4);
        Assert.assertNotEquals((Object)s4, (Object)s2);
        Assert.assertNotEquals((Object)s3, (Object)s4);
        Assert.assertNotEquals((Object)s4, (Object)s3);
        Assert.assertNotEquals((long)s1.hashCode(), (long)s4.hashCode());
        Assert.assertNotEquals((long)s2.hashCode(), (long)s4.hashCode());
        Assert.assertNotEquals((long)s3.hashCode(), (long)s4.hashCode());
    }
}

