/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileResolverTestBase;
import io.vertx.core.file.ZipFileResolverTest;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class NestedZipFileResolverTest
extends FileResolverTestBase {
    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File nestedFiles = Files.createTempFile(TestUtils.MAVEN_TARGET_DIR.toPath(), "", "nested-files.zip", new FileAttribute[0]).toFile();
        File files = ZipFileResolverTest.getFiles(baseDir);
        try (JarOutputStream jar = new JarOutputStream(new FileOutputStream(nestedFiles));){
            jar.putNextEntry(new JarEntry("lib/"));
            jar.closeEntry();
            jar.putNextEntry(new JarEntry("lib/nested.zip"));
            jar.write(Files.readAllBytes(files.toPath()));
            jar.closeEntry();
        }
        final URL webrootURL = nestedFiles.toURI().toURL();
        return new ClassLoader(Thread.currentThread().getContextClassLoader()){

            @Override
            public URL getResource(String name) {
                try {
                    if (name.startsWith("lib/")) {
                        return new URL("jar:" + webrootURL + "!/" + name);
                    }
                    if (name.startsWith("webroot")) {
                        return new URL("jar:" + webrootURL + "!/lib/nested.zip!/" + name.substring(7));
                    }
                    if (name.equals("afile.html")) {
                        return new URL("jar:" + webrootURL + "!/lib/nested.zip!afile.html/");
                    }
                    if (name.equals("afile with spaces.html")) {
                        return new URL("jar:" + webrootURL + "!/lib/nested.zip!afile with spaces.html/");
                    }
                    if (name.equals("afilewithspaceatend ")) {
                        return new URL("jar:" + webrootURL + "!/lib/nested.zip!afilewithspaceatend /");
                    }
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                return super.getResource(name);
            }
        };
    }
}

