/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.InvalidValueException;
import io.vertx.core.cli.MissingOptionException;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.TypedArgument;
import io.vertx.core.cli.TypedOption;
import io.vertx.core.cli.annotations.CLIConfigurator;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.impl.DefaultCLI;
import java.io.File;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultParserTest {
    private CLI cli;

    @Before
    public void setUp() {
        this.cli = new DefaultCLI().setName("test");
    }

    @Test
    public void testWithOneLongOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Collections.singletonList("--file=hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
        StringBuilder usage = new StringBuilder();
        this.cli.usage(usage);
        Assertions.assertThat((String)usage.toString()).startsWith((CharSequence)"Usage: test [-f <value>]");
        Assertions.assertThat((String)usage.toString()).contains(new CharSequence[]{"-f,--file <value>"});
    }

    @Test
    public void testWithOneLongOptionUsingSpace() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("--file", "hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
        StringBuilder usage = new StringBuilder();
        this.cli.usage(usage);
        Assertions.assertThat((String)usage.toString()).startsWith((CharSequence)"Usage: test [-f <value>]");
    }

    @Test
    public void testWithOneShortOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Collections.singletonList("-f=hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
    }

    @Test
    public void testWithOneShortOptionUsingSpace() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-f", "hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
    }

    @Test
    public void testTheDifferentFormatForLongOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("--file", "hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("--file=hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("-filehello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Arrays.asList("--FILE", "hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
    }

    @Test
    public void testTheDifferentFormatForShortOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-f", "hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("-f=hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("-fhello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
    }

    @Test
    public void testWithMultipleValues() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setMultiValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-f=hello.txt", "--file=hello2.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt", "hello2.txt"});
    }

    @Test
    public void testWithList() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("file").setParsedAsList(true).setType(String.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Collections.singletonList("-f=hello.txt,hello2.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt,hello2.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt", "hello2.txt"});
    }

    @Test
    public void testWithFlag() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setType(Boolean.TYPE).setShortName("f").setLongName("flag").setFlag(true).setSingleValued(true), new TypedOption().setType(Boolean.TYPE).setShortName("f2").setLongName("flag2").setFlag(true).setSingleValued(true), new TypedOption().setType(Boolean.TYPE).setShortName("f3").setLongName("flag3").setFlag(true)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("--flag", "--flag2", "--flag3"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(true);
        evaluated = cli.parse(Arrays.asList("--flag=true", "--flag2=false", "--flag3"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(false);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(true);
        evaluated = cli.parse(Arrays.asList("--flag", "--flag2"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(false);
        evaluated = cli.parse(Arrays.asList("--flag", "true", "--flag2", "false", "--flag3"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(false);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(true);
    }

    @Test
    public void testArguments() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("org.acme.Foo", "-f=no"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"org.acme.Foo"});
        evaluated = this.cli.parse(Arrays.asList("-f=no", "org.acme.Foo"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"org.acme.Foo"});
        evaluated = this.cli.parse(Arrays.asList("-f=no", "org.acme.Foo", "bar"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"org.acme.Foo", "bar"});
    }

    @Test
    public void testUnknownOption() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setRequired(true).setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-flag=true", "-unknown=x"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"-unknown=x"});
    }

    @Test(expected=MissingOptionException.class)
    public void testNotFulfilledRequiredOptions() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setRequired(true).setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Collections.emptyList());
    }

    @Test
    public void testRequiredOptions() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setRequired(true).setFlag(true)};
        this.cli.addOptions(Arrays.asList(options));
        this.cli.parse(Collections.singletonList("-f"));
    }

    @Test
    public void testQuotedValues() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("--file", "\"hello.txt\""));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
    }

    @Test
    public void testNegativeNumbers() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setLongName("num").setSingleValued(true).setType(Double.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("--num", "-1.5"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((List)cli.getArguments()).isEmpty();
        Assertions.assertThat((double)((Double)evaluated.getOptionValue("num"))).isEqualTo(-1.5);
        evaluated = cli.parse(Collections.singletonList("--num=-1.5"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((List)cli.getArguments()).isEmpty();
        Assertions.assertThat((double)((Double)evaluated.getOptionValue("num"))).isEqualTo(-1.5);
    }

    @Test(expected=MissingValueException.class)
    public void testMissingValue() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        this.cli.parse(Collections.singletonList("--file"));
    }

    @Test
    public void testVertxRun() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setLongName("conf").setType(String.class).setSingleValued(true), new TypedOption().setLongName("instances").setType(Integer.class).setSingleValued(true).setDefaultValue("1"), new TypedOption().setLongName("worker").setType(Boolean.class).setFlag(true), new TypedOption().setLongName("classpath").setShortName("cp").setListSeparator(File.pathSeparator).setType(String.class).setSingleValued(true), new TypedOption().setLongName("cluster").setType(Boolean.class).setFlag(true), new TypedOption().setLongName("cluster-port").setType(Integer.class).setSingleValued(true), new TypedOption().setLongName("cluster-host").setType(String.class).setSingleValued(true), new TypedOption().setLongName("ha").setType(Boolean.class).setFlag(true).setSingleValued(true), new TypedOption().setLongName("quorum").setType(Integer.class).setSingleValued(true), new TypedOption().setLongName("ha-group").setType(String.class).setDefaultValue("__DEFAULT__").setSingleValued(true)};
        cli.addOptions(Arrays.asList(options));
        cli.addArgument((Argument)new TypedArgument().setType(String.class).setArgName("verticle").setIndex(0).setRequired(false));
        CommandLine evaluated = cli.parse(Collections.singletonList("-ha"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isNull();
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isNull();
        evaluated = cli.parse(Arrays.asList("-ha", "true"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        evaluated = cli.parse(Collections.singletonList("-ha=true"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        evaluated = cli.parse(Collections.singletonList("--ha"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        evaluated = cli.parse(Arrays.asList("--ha", "false"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isFalse();
        evaluated = cli.parse(Collections.singletonList("--ha=no"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isFalse();
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-instances=4", "-cp", "." + File.pathSeparator + "my.jar"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        int instances = (Integer)evaluated.getOptionValue("instances");
        List classpath = evaluated.getOptionValues("classpath");
        Assertions.assertThat((int)instances).isEqualTo(4);
        Assertions.assertThat((List)classpath).containsExactly((Object[])new String[]{".", "my.jar"});
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "--cluster"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "-cluster-host", "127.0.0.1"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "--cluster-host", "127.0.0.1"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "-cluster-host=127.0.0.1"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "-cluster-host", "127.0.0.1", "-cluster-port", "1234"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        Assertions.assertThat((int)((Integer)evaluated.getOptionValue("cluster-port"))).isEqualTo(1234);
    }

    @Test
    public void testWithDashD() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setShortName("D").setLongName("systemProperty").setMultiValued(true).setType(String.class), new TypedOption().setShortName("F").setLongName("flag").setFlag(true).setType(Boolean.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("-Dx=y", "-F"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(2);
        Assertions.assertThat((String)evaluated.getRawValueForOption(evaluated.cli().getOption("systemProperty"))).isEqualTo((Object)"x=y");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isTrue();
    }

    @Test
    public void testConcatenatedOptions() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setShortName("d").setFlag(true).setType(Boolean.class), new TypedOption().setShortName("e").setFlag(true).setType(Boolean.class), new TypedOption().setShortName("f").setFlag(true).setType(Boolean.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("-d", "-e", "-f"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("d"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("e"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("f"))).isTrue();
        evaluated = cli.parse(Collections.singletonList("-de"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("d"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("e"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("f"))).isFalse();
        evaluated = cli.parse(Collections.singletonList("-def"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("d"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("e"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("f"))).isTrue();
    }

    @Test(expected=CLIException.class)
    public void testThatNonUniqueArgumentIndexAreDetected() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument().setIndex(0));
        cli.addArgument(new Argument().setIndex(1));
        cli.addArgument(new Argument().setIndex(1));
        cli.parse(Arrays.asList("a", "b", "c"));
    }

    @Test(expected=CLIException.class)
    public void testThatOnlyTheLastArgumentCanBeMultivalued() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument().setIndex(0));
        cli.addArgument(new Argument().setIndex(1).setMultiValued(true));
        cli.addArgument(new Argument().setIndex(2));
        cli.parse(Arrays.asList("a", "b", "c", "d"));
    }

    @Test(expected=CLIException.class)
    public void testThatOnlyOneArgumentCanBeMultivalued() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument().setIndex(0));
        cli.addArgument(new Argument().setIndex(1).setMultiValued(true));
        cli.addArgument(new Argument().setIndex(2).setMultiValued(true));
        cli.parse(Arrays.asList("a", "b", "c", "d"));
    }

    @Test
    public void testWhenThereAreNoDeclaredArguments() {
        CLI cli = new DefaultCLI().setName("test");
        CommandLine cl = cli.parse(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((List)cl.allArguments()).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void testWithArgumentReceivingMultipleValues() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument().setIndex(0).setArgName("arg").setDescription("argument1"));
        cli.addArgument(new Argument().setIndex(1).setMultiValued(true).setArgName("m").setDescription("multiple arg"));
        CommandLine cl = cli.parse(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((String)((String)cl.getArgumentValue(0))).isEqualTo((Object)"a");
        Assertions.assertThat((List)cl.getArgumentValues(1)).containsExactly(new Object[]{"b", "c"});
        Assertions.assertThat((String)((String)cl.getArgumentValue(1))).isEqualTo((Object)"b");
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((String)builder.toString()).contains(new CharSequence[]{"test arg m..."});
    }

    @Test
    public void testAnnotatedClassWithArgumentReceivingMultipleValues() {
        CLI cli = CLI.create(CLIUsingMultipleArgument.class);
        CLIUsingMultipleArgument instance = new CLIUsingMultipleArgument();
        CommandLine cl = cli.parse(Arrays.asList("a", "b", "-s=1", "-s=2"));
        CLIConfigurator.inject((CommandLine)cl, (Object)instance);
    }

    @Test
    public void testWithMultipleArgumentReceivingSingleValues() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument().setIndex(0));
        cli.addArgument(new Argument().setIndex(1).setMultiValued(true));
        CommandLine cl = cli.parse(Arrays.asList("a", "b"));
        Assertions.assertThat((String)((String)cl.getArgumentValue(0))).isEqualTo((Object)"a");
        Assertions.assertThat((List)cl.getArgumentValues(1)).containsExactly(new Object[]{"b"});
        Assertions.assertThat((String)((String)cl.getArgumentValue(1))).isEqualTo((Object)"b");
    }

    @Test
    public void testWithMultipleRequiredArgument() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument().setIndex(0));
        cli.addArgument(new Argument().setIndex(1).setMultiValued(true).setRequired(true));
        CommandLine cl = cli.parse(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((String)((String)cl.getArgumentValue(0))).isEqualTo((Object)"a");
        Assertions.assertThat((List)cl.getArgumentValues(1)).containsExactly(new Object[]{"b", "c"});
        Assertions.assertThat((String)((String)cl.getArgumentValue(1))).isEqualTo((Object)"b");
        cl = cli.parse(Arrays.asList("a", "b"));
        Assertions.assertThat((String)((String)cl.getArgumentValue(0))).isEqualTo((Object)"a");
        Assertions.assertThat((List)cl.getArgumentValues(1)).containsExactly(new Object[]{"b"});
        Assertions.assertThat((String)((String)cl.getArgumentValue(1))).isEqualTo((Object)"b");
        try {
            cli.parse(Collections.singletonList("a"));
            Assert.fail((String)"required argument not fultilled");
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    @Test
    public void testThatArgumentIndexCanBeGenerated() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument());
        cli.addArgument(new Argument());
        cli.addArgument(new Argument().setMultiValued(true));
        CommandLine line = cli.parse(Arrays.asList("a", "b", "c", "d"));
        Assertions.assertThat((String)((String)line.getArgumentValue(0))).isEqualToIgnoringCase((CharSequence)"a");
        Assertions.assertThat((String)((String)line.getArgumentValue(1))).isEqualToIgnoringCase((CharSequence)"b");
        Assertions.assertThat((List)line.getArgumentValues(2)).containsExactly(new Object[]{"c", "d"});
    }

    @Test
    public void testThatArgumentIndexCanBeGeneratedWithPartiallyNumberedArguments() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addArgument(new Argument());
        cli.addArgument(new Argument().setIndex(1));
        cli.addArgument(new Argument().setMultiValued(true));
        CommandLine line = cli.parse(Arrays.asList("a", "b", "c", "d"));
        Assertions.assertThat((String)((String)line.getArgumentValue(0))).isEqualToIgnoringCase((CharSequence)"a");
        Assertions.assertThat((String)((String)line.getArgumentValue(1))).isEqualToIgnoringCase((CharSequence)"b");
        Assertions.assertThat((List)line.getArgumentValues(2)).containsExactly(new Object[]{"c", "d"});
    }

    @Test
    public void testHelpOption() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addOption(new Option().setLongName("foo").setRequired(true));
        cli.addOption(new Option().setLongName("help").setShortName("h").setHelp(true).setFlag(true));
        CommandLine line = cli.parse(Collections.singletonList("--foo=bar"));
        Assertions.assertThat((boolean)line.isValid()).isTrue();
        Assertions.assertThat((String)((String)line.getOptionValue("foo"))).isEqualTo((Object)"bar");
        Assertions.assertThat((boolean)line.isAskingForHelp()).isFalse();
        line = cli.parse(Arrays.asList("--foo=bar", "-h"));
        Assertions.assertThat((boolean)line.isValid()).isTrue();
        Assertions.assertThat((String)((String)line.getOptionValue("foo"))).isEqualTo((Object)"bar");
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        line = cli.parse(Collections.singletonList("-h"));
        Assertions.assertThat((boolean)line.isValid()).isFalse();
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        line = cli.parse(Collections.singletonList("-h"), false);
        Assertions.assertThat((boolean)line.isValid()).isFalse();
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        line = cli.parse(Arrays.asList("--foo=bar", "-h"), false);
        Assertions.assertThat((boolean)line.isValid()).isTrue();
        Assertions.assertThat((String)((String)line.getOptionValue("foo"))).isEqualTo((Object)"bar");
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        try {
            cli.parse(Collections.emptyList());
            Assert.fail((String)"Exception expected");
        }
        catch (MissingOptionException missingOptionException) {
            // empty catch block
        }
    }

    @Test
    public void testHelpOptionUsingAnnotation() {
        CLI cli = CLIConfigurator.define(CLIUsingAHelpOption.class);
        CommandLine line = cli.parse(Collections.singletonList("--foo=bar"));
        Assertions.assertThat((boolean)line.isValid()).isTrue();
        Assertions.assertThat((String)((String)line.getOptionValue("foo"))).isEqualTo((Object)"bar");
        Assertions.assertThat((boolean)line.isAskingForHelp()).isFalse();
        line = cli.parse(Arrays.asList("--foo=bar", "-h"));
        Assertions.assertThat((boolean)line.isValid()).isTrue();
        Assertions.assertThat((String)((String)line.getOptionValue("foo"))).isEqualTo((Object)"bar");
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        line = cli.parse(Collections.singletonList("-h"));
        Assertions.assertThat((boolean)line.isValid()).isFalse();
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        line = cli.parse(Collections.singletonList("-h"), false);
        Assertions.assertThat((boolean)line.isValid()).isFalse();
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        line = cli.parse(Arrays.asList("--foo=bar", "-h"), false);
        Assertions.assertThat((boolean)line.isValid()).isTrue();
        Assertions.assertThat((String)((String)line.getOptionValue("foo"))).isEqualTo((Object)"bar");
        Assertions.assertThat((boolean)line.isFlagEnabled("help")).isTrue();
        Assertions.assertThat((boolean)line.isAskingForHelp()).isTrue();
        try {
            cli.parse(Collections.emptyList());
            Assert.fail((String)"Exception expected");
        }
        catch (MissingOptionException missingOptionException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionsWithChoices() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addOption(new Option().setLongName("color").addChoice("red").addChoice("blue").addChoice("green"));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((String)builder.toString()).contains(new CharSequence[]{"[--color {blue, green, red}]"}).contains(new CharSequence[]{"  --color {blue, green, red}"});
        CommandLine line = cli.parse(Arrays.asList("--color", "blue"));
        Assertions.assertThat((String)((String)line.getOptionValue("color"))).isEqualTo((Object)"blue");
        try {
            cli.parse(Collections.singletonList("--color=black"));
            Assert.fail((String)"Invalid value expected");
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionsWithChoicesAndDefault() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addOption(new Option().setLongName("color").addChoice("red").addChoice("blue").addChoice("green").setDefaultValue("green"));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((String)builder.toString()).contains(new CharSequence[]{"[--color {blue, green, red}]"}).contains(new CharSequence[]{"  --color {blue, green, red}"});
        CommandLine line = cli.parse(Arrays.asList("--color", "blue"));
        Assertions.assertThat((String)((String)line.getOptionValue("color"))).isEqualTo((Object)"blue");
        try {
            cli.parse(Collections.singletonList("--color=black"));
            Assert.fail((String)"Invalid value expected");
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        line = cli.parse(Collections.emptyList());
        Assertions.assertThat((String)((String)line.getOptionValue("color"))).isEqualTo((Object)"green");
    }

    @Test
    public void testOptionsWithChoicesUsingEnum() {
        CLI cli = new DefaultCLI().setName("test");
        cli.addOption((Option)new TypedOption().setLongName("retention").setType(RetentionPolicy.class));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((String)builder.toString()).contains(new CharSequence[]{"[--retention {CLASS, RUNTIME, SOURCE}]"}).contains(new CharSequence[]{"  --retention {CLASS, RUNTIME, SOURCE}"});
        CommandLine line = cli.parse(Arrays.asList("--retention", "CLASS"));
        Assertions.assertThat((Comparable)((Object)((RetentionPolicy)((Object)line.getOptionValue("retention"))))).isEqualTo((Object)RetentionPolicy.CLASS);
        try {
            cli.parse(Collections.singletonList("--retention=nope"));
            Assert.fail((String)"Invalid value expected");
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionsWithChoicesUsingAnnotations() {
        CLI cli = CLIConfigurator.define(CLIUsingAEnumOption.class);
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((String)builder.toString()).contains(new CharSequence[]{"[--retention {CLASS, RUNTIME, SOURCE}]"}).contains(new CharSequence[]{"  --retention {CLASS, RUNTIME, SOURCE}"});
        CommandLine line = cli.parse(Arrays.asList("--retention", "CLASS", "--foo", "bar"));
        Assertions.assertThat((Comparable)((Object)((RetentionPolicy)((Object)line.getOptionValue("retention"))))).isEqualTo((Object)RetentionPolicy.CLASS);
        try {
            cli.parse(Collections.singletonList("--retention=nope"));
            Assert.fail((String)"Invalid value expected");
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
    }

    @Test
    public void testGetOptionValueWithCaseSensitivityConflict() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setShortName("a").setLongName("longname")).addOption(new Option().setShortName("A").setLongName("LONGNAME"));
        String lowercaseValue = "someValue";
        String uppercaseValue = "someOtherValue";
        CommandLine commandLine = cli.parse(Arrays.asList("-a", lowercaseValue, "-A", uppercaseValue));
        Assertions.assertThat((String)((String)commandLine.getOptionValue("a"))).isEqualTo((Object)lowercaseValue);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("A"))).isEqualTo((Object)uppercaseValue);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("longname"))).isEqualTo((Object)lowercaseValue);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("LONGNAME"))).isEqualTo((Object)uppercaseValue);
        commandLine = cli.parse(Arrays.asList("--longname", lowercaseValue, "--LONGNAME", uppercaseValue));
        Assertions.assertThat((String)((String)commandLine.getOptionValue("a"))).isEqualTo((Object)lowercaseValue);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("A"))).isEqualTo((Object)uppercaseValue);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("longname"))).isEqualTo((Object)lowercaseValue);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("LONGNAME"))).isEqualTo((Object)uppercaseValue);
    }

    @Test
    public void testGetOptionValueWithoutCaseSensitivityConflict() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setShortName("a").setLongName("lowercase"));
        String value = "foo";
        CommandLine commandLine = cli.parse(Arrays.asList("-a", value));
        Assertions.assertThat((String)((String)commandLine.getOptionValue("a"))).isEqualTo((Object)value);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("A"))).isEqualTo((Object)value);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("lowercase"))).isEqualTo((Object)value);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("LOWERCASE"))).isEqualTo((Object)value);
        commandLine = cli.parse(Arrays.asList("--lowercase", value));
        Assertions.assertThat((String)((String)commandLine.getOptionValue("a"))).isEqualTo((Object)value);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("A"))).isEqualTo((Object)value);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("lowercase"))).isEqualTo((Object)value);
        Assertions.assertThat((String)((String)commandLine.getOptionValue("LOWERCASE"))).isEqualTo((Object)value);
    }

    @Name(value="test")
    private class CLIUsingMultipleArgument {
        private CLIUsingMultipleArgument() {
        }

        @io.vertx.core.cli.annotations.Argument(index=0)
        public void setList(List<String> s) {
            if (s.size() != 2) {
                throw new IllegalArgumentException("2 arguments expected");
            }
        }

        @io.vertx.core.cli.annotations.Option(shortName="s")
        public void setOpts(List<String> s) {
            if (s.size() != 2) {
                throw new IllegalArgumentException("2 values expected");
            }
        }
    }

    @Name(value="test")
    private class CLIUsingAEnumOption {
        private CLIUsingAEnumOption() {
        }

        @io.vertx.core.cli.annotations.Option(longName="retention")
        public void setRetention(RetentionPolicy retention) {
        }

        @io.vertx.core.cli.annotations.Option(longName="foo", required=true)
        public void setFoo(String f) {
        }
    }

    @Name(value="test")
    private class CLIUsingAHelpOption {
        private CLIUsingAHelpOption() {
        }

        @io.vertx.core.cli.annotations.Option(help=true, flag=true, shortName="h", longName="help")
        public void setHelp(boolean b) {
        }

        @io.vertx.core.cli.annotations.Option(longName="foo", required=true)
        public void setFoo(String f) {
        }
    }
}

