/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.impl.IsolatingClassLoader;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Scanner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IsolatingClassLoaderTest {
    private String resourceName = "resource.json";
    private URL url1;
    private URL url2;
    private URL url3;
    private URLClassLoader ucl;
    private IsolatingClassLoader icl;

    @Before
    public void setUp() throws Exception {
        String basePath = "src/test/resources/icl";
        this.url1 = new File(basePath, "pkg1").toURI().toURL();
        this.url2 = new File(basePath, "pkg2").toURI().toURL();
        this.url3 = new File(basePath, "pkg3").toURI().toURL();
        this.ucl = new URLClassLoader(new URL[]{this.url2, this.url3});
        this.icl = new IsolatingClassLoader(new URL[]{this.url1}, (ClassLoader)this.ucl, null);
    }

    @Test
    public void testGetResource() throws Exception {
        URL resource = this.ucl.getResource(this.resourceName);
        this.checkResource(this.url2, resource);
        resource = this.icl.getResource(this.resourceName);
        this.checkResource(this.url1, resource);
    }

    @Test
    public void testGetResourceNull() throws Exception {
        this.resourceName = "null_resource";
        URL resource = this.ucl.getResource(this.resourceName);
        Assert.assertNull((Object)resource);
        resource = this.icl.getResource(this.resourceName);
        Assert.assertNull((Object)resource);
    }

    @Test
    public void testGetResources() throws Exception {
        Enumeration resources = this.ucl.getResources(this.resourceName);
        ArrayList<URL> list = Collections.list(resources);
        Assert.assertEquals((long)2L, (long)list.size());
        this.checkResource(this.url2, (URL)list.get(0));
        this.checkResource(this.url3, (URL)list.get(1));
        resources = this.icl.getResources(this.resourceName);
        list = Collections.list(resources);
        Assert.assertEquals((long)3L, (long)list.size());
        this.checkResource(this.url1, (URL)list.get(0));
        this.checkResource(this.url2, (URL)list.get(1));
        this.checkResource(this.url3, (URL)list.get(2));
    }

    private void checkResource(URL expected, URL resource) throws Exception {
        Assert.assertEquals((Object)(expected.toString() + this.resourceName), (Object)resource.toString());
    }

    @Test
    public void testGetResourcesNull() throws Exception {
        this.resourceName = "null_resource";
        Enumeration resources = this.ucl.getResources(this.resourceName);
        ArrayList<URL> list = Collections.list(resources);
        Assert.assertEquals((long)0L, (long)list.size());
        resources = this.icl.getResources(this.resourceName);
        list = Collections.list(resources);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testGetResourceAsStream() throws Exception {
        this.testGetResourceAsStream(2L, this.ucl);
        this.testGetResourceAsStream(1L, (ClassLoader)this.icl);
    }

    private void testGetResourceAsStream(long ver, ClassLoader cl) throws Exception {
        try (InputStream is = cl.getResourceAsStream(this.resourceName);){
            Assert.assertNotNull((Object)is);
            try (Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");){
                Assert.assertTrue((boolean)scanner.hasNext());
                JsonObject json = new JsonObject(scanner.next());
                Assert.assertEquals((long)ver, (long)json.getLong("ver", Long.valueOf(-1L)));
            }
        }
    }
}

