/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.policy;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class AclPolicy {
    private static final String ID_KEY = "ID";
    private static final String NAME_KEY = "Name";
    private static final String DESCRIPTION_KEY = "Description";
    private static final String RULES_KEY = "Rules";
    private static final String DATACENTERS_KEY = "Datacenters";
    private static final String NAMESPACE_KEY = "Namespace";
    private String id;
    private String name;
    private String description;
    private String rules;
    private List<String> datacenters;
    private String namespace;

    public AclPolicy() {
    }

    public AclPolicy(JsonObject json) {
        this.id = json.getString(ID_KEY);
        this.name = json.getString(NAME_KEY);
        this.rules = json.getString(RULES_KEY);
        this.description = json.getString(DESCRIPTION_KEY);
        JsonArray datacenters = json.getJsonArray(DATACENTERS_KEY);
        if (datacenters != null && !datacenters.isEmpty()) {
            this.datacenters = new ArrayList<String>();
            for (int i = 1; i < datacenters.size(); ++i) {
                this.datacenters.add(datacenters.getString(i));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRules() {
        return this.rules;
    }

    public List<String> getDatacenters() {
        return this.datacenters;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.name != null) {
            jsonObject.put(NAME_KEY, (Object)this.name);
        }
        if (this.description != null) {
            jsonObject.put(DESCRIPTION_KEY, (Object)this.description);
        }
        if (this.rules != null) {
            jsonObject.put(RULES_KEY, (Object)this.rules);
        }
        if (this.datacenters != null && !this.datacenters.isEmpty()) {
            JsonArray array = new JsonArray(this.datacenters);
            jsonObject.put(DATACENTERS_KEY, (Object)array);
        }
        if (this.namespace != null) {
            jsonObject.put(NAMESPACE_KEY, (Object)this.namespace);
        }
        return jsonObject;
    }

    public AclPolicy setName(String name) {
        this.name = name;
        return this;
    }

    public AclPolicy setDescription(String description) {
        this.description = description;
        return this;
    }

    public AclPolicy setRules(String rules) {
        this.rules = rules;
        return this;
    }

    public AclPolicy setDatacenters(List<String> datacenters) {
        this.datacenters = datacenters;
        return this;
    }

    public AclPolicy addDatacenter(String datacenter) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        this.datacenters.add(datacenter);
        return this;
    }

    public AclPolicy setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }
}

