/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.FileSet;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitConfigStore
implements ConfigStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitConfigStore.class);
    private final VertxInternal vertx;
    private final File path;
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final String url;
    private final String branch;
    private final String remote;
    private final Git git;
    private final CredentialsProvider credentialProvider;
    private final TransportConfigCallback transportConfigCallback;

    public GitConfigStore(Vertx vertx, final JsonObject configuration) {
        this.vertx = (VertxInternal)vertx;
        String path = Objects.requireNonNull(configuration.getString("path"), "The `path` configuration is required.");
        this.path = new File(path);
        if (this.path.isFile()) {
            throw new IllegalArgumentException("The `path` must not be a file");
        }
        JsonArray filesets = Objects.requireNonNull(configuration.getJsonArray("filesets"), "The `filesets` element is required.");
        for (Object o : filesets) {
            JsonObject json = (JsonObject)o;
            FileSet set = new FileSet(vertx, this.path, json);
            this.filesets.add(set);
        }
        this.url = Objects.requireNonNull(configuration.getString("url"), "The `url` configuration (Git repository location) is required.");
        this.branch = configuration.getString("branch", "master");
        this.remote = configuration.getString("remote", "origin");
        this.credentialProvider = Objects.nonNull(configuration.getString("user")) && Objects.nonNull(configuration.getString("password")) ? new UsernamePasswordCredentialsProvider(configuration.getString("user"), configuration.getString("password")) : null;
        if (Objects.nonNull(configuration.getString("idRsaKeyPath"))) {
            JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host host, Session session) {
                }

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
                    defaultJSch.addIdentity(configuration.getString("idRsaKeyPath"));
                    return defaultJSch;
                }
            };
            this.transportConfigCallback = new TransportConfigCallback((SshSessionFactory)sshSessionFactory){
                final /* synthetic */ SshSessionFactory val$sshSessionFactory;
                {
                    this.val$sshSessionFactory = sshSessionFactory;
                }

                public void configure(Transport transport) {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory(this.val$sshSessionFactory);
                }
            };
        } else {
            this.transportConfigCallback = null;
        }
        try {
            this.git = this.initializeGit();
        }
        catch (Exception e) {
            throw new VertxException("Unable to initialize the Git repository", (Throwable)e);
        }
    }

    private Git initializeGit() throws IOException, GitAPIException {
        if (this.path.isDirectory()) {
            Git git = Git.open((File)this.path);
            String current = git.getRepository().getBranch();
            if (this.branch.equalsIgnoreCase(current)) {
                PullResult pull = ((PullCommand)((PullCommand)git.pull().setRemote(this.remote).setCredentialsProvider(this.credentialProvider)).setTransportConfigCallback(this.transportConfigCallback)).call();
                if (!pull.isSuccessful()) {
                    LOGGER.warn((Object)("Unable to pull the branch + '" + this.branch + "' from the remote repository '" + this.remote + "'"));
                }
                return git;
            }
            git.checkout().setName(this.branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(this.remote + "/" + this.branch).call();
            return git;
        }
        return ((CloneCommand)((CloneCommand)Git.cloneRepository().setURI(this.url).setBranch(this.branch).setRemote(this.remote).setDirectory(this.path).setCredentialsProvider(this.credentialProvider)).setTransportConfigCallback(this.transportConfigCallback)).call();
    }

    public Future<Buffer> get() {
        return this.update().compose(v -> this.read()).compose(this::compute);
    }

    private Future<Buffer> compute(List<File> files) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (FileSet set : this.filesets) {
            Promise future = Promise.promise();
            set.buildConfiguration(files, json -> {
                if (json.failed()) {
                    future.fail(json.cause());
                } else {
                    future.complete(json.result());
                }
            });
            futures.add(future.future());
        }
        return CompositeFuture.all(futures).map(compositeFuture -> {
            JsonObject json = new JsonObject();
            compositeFuture.list().stream().forEach(config -> json.mergeIn(config, true));
            return json.toBuffer();
        });
    }

    private Future<Void> update() {
        return this.vertx.executeBlocking(promise -> {
            try {
                PullResult call = ((PullCommand)((PullCommand)this.git.pull().setRemote(this.remote).setRemoteBranchName(this.branch).setCredentialsProvider(this.credentialProvider)).setTransportConfigCallback(this.transportConfigCallback)).call();
                promise.complete((Object)call);
            }
            catch (GitAPIException e) {
                promise.fail((Throwable)e);
            }
        }).flatMap(call -> {
            if (call.isSuccessful()) {
                return Future.succeededFuture();
            }
            if (call.getMergeResult() != null) {
                return Future.failedFuture((String)("Unable to merge repository - Conflicts: " + call.getMergeResult().getCheckoutConflicts()));
            }
            return Future.failedFuture((String)("Unable to rebase repository - Conflicts: " + call.getRebaseResult().getConflicts()));
        });
    }

    private Future<List<File>> read() {
        return this.vertx.executeBlocking(promise -> promise.complete(FileSet.traverse((File)this.path).stream().sorted().collect(Collectors.toList())));
    }

    public Future<Void> close() {
        return this.vertx.executeBlocking(promise -> {
            this.git.close();
            promise.complete();
        });
    }
}

