/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.generator.gen1;

import io.vertx.codegen.EnumValueInfo;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.Model;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.TypeInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class TestGenerator
extends Generator<Model> {
    public TestGenerator() {
        this.name = "testgen1";
        this.kinds = new HashSet<String>(Arrays.asList("dataObject", "class", "enum", "module"));
    }

    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(DataObject.class, ModuleGen.class, VertxGen.class);
    }

    public String filename(Model model) {
        return model.getFqn().replace('.', '_') + ".properties";
    }

    private String format(Map<String, Object> vars) {
        StringBuilder sb = new StringBuilder();
        vars.forEach((k, v) -> {
            Iterable list;
            Iterator it;
            if (v instanceof Iterable && (it = (list = (Iterable)v).iterator()).hasNext()) {
                Object elt = it.next();
                if (elt instanceof TypeInfo) {
                    TreeMap<String, TypeInfo> map = new TreeMap<String, TypeInfo>();
                    Iterable types = list;
                    for (TypeInfo type : types) {
                        map.put(type.getName(), type);
                    }
                    sb.append((String)k).append('=').append(map.values()).append('\n');
                    return;
                }
                if (elt instanceof PropertyInfo) {
                    Iterable props = list;
                    props.forEach(prop -> sb.append("property.").append(prop.getName()).append("=").append(prop.getType()).append("\n"));
                    return;
                }
                if (elt instanceof MethodInfo) {
                    Iterable methods = list;
                    methods.forEach(method -> sb.append("method.").append(method.getName()).append(method.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(",", "(", ")"))).append("=").append(method.getReturnType()).append("\n"));
                    return;
                }
                if (elt instanceof EnumValueInfo) {
                    Iterable values = list;
                    sb.append("values=");
                    values.forEach(prop -> {
                        sb.append(prop.getIdentifier());
                        sb.append(",");
                    });
                    sb.setCharAt(sb.length() - 1, '\n');
                    return;
                }
            }
            sb.append((String)k).append('=').append(v).append("\n");
        });
        return sb.toString();
    }

    public String render(Model model, int index, int size, Map<String, Object> session) {
        Map vars = model.getVars();
        return this.format(vars);
    }
}

