/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.ModuleModel;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.TypeNameTranslator;
import io.vertx.test.codegen.GeneratorHelper;
import io.vertx.test.codegen.test_module_with_underscore_pkg.TestApi;
import io.vertx.test.codegen.testmodule.emptypkg.empty.sub.EmptyPkg;
import io.vertx.test.codegen.testmodule.modulescoped.ModuleScopedApi;
import io.vertx.test.codegen.testmodule.modulescoped.ModuleScopedDataObject;
import io.vertx.test.codegen.testmodule.modulescoped.sub.ModuleScopedSubApi;
import io.vertx.test.codegen.testmodule.modulescoped.sub.ModuleScopedSubDataObject;
import io.vertx.test.codegen.testmodule.nestingmodule.nestedmodule.NestedApi;
import io.vertx.test.codegen.testmodule.nestingmodule.nestedmodule.NestedDataObject;
import io.vertx.test.codegen.testmodule.nomodule.NoModuleApi;
import io.vertx.test.codegen.testmodule.nomodule.NoModuleDataObject;
import io.vertx.test.codegen.testmodule.vertx.core.VertxCoreModuleScopedApi;
import io.vertx.test.codegen.testmodule.vertx.other.VertxOtherModuleScopedApi;
import org.junit.Assert;
import org.junit.Test;

public class ModuleTest {
    @Test
    public void testModuleModel() throws Exception {
        ModuleModel model = new GeneratorHelper().generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testmodule.modulescoped");
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.modulescoped", (Object)model.getFqn());
        Assert.assertEquals((Object)"simple", (Object)model.getName());
        Assert.assertEquals((Object)"io.vertx.test.groovy.codegen.testmodule.modulescoped", (Object)model.translateFqn("groovy"));
        Assert.assertNotNull((Object)model.getModule());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.modulescoped", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"simple", (Object)model.getModule().getName());
        Assert.assertEquals((Object)"io.vertx.test.groovy.codegen.testmodule.modulescoped", (Object)model.getModule().translatePackageName("groovy"));
    }

    @Test
    public void testNestedModuleModel() throws Exception {
        ModuleModel module = new GeneratorHelper().generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testmodule.nestingmodule.nestedmodule");
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.nestingmodule.nestedmodule", (Object)module.getFqn());
        Assert.assertEquals((Object)"nested", (Object)module.getName());
        Assert.assertEquals((Object)"io.vertx.test.groovy.codegen.testmodule.nestingmodule.nestedmodule", (Object)module.translateFqn("groovy"));
        ClassModel api = new GeneratorHelper().generateClass(NestedApi.class, new Class[0]);
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.nestingmodule.nestedmodule", (Object)api.getModule().getPackageName());
        Assert.assertEquals((Object)"nested", (Object)api.getModule().getName());
        DataObjectModel dataObj = new GeneratorHelper().generateDataObject(NestedDataObject.class, new Class[0]);
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.nestingmodule.nestedmodule", (Object)dataObj.getModule().getPackageName());
        Assert.assertEquals((Object)"nested", (Object)dataObj.getModule().getName());
    }

    @Test
    public void testEmptyNameModuleModel() throws Exception {
        try {
            new GeneratorHelper().generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testmodule.emptynamemodule");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalNameModuleModel() throws Exception {
        try {
            new GeneratorHelper().generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testmodule.illegalnamemodule");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testCustomGroupModuleModel() throws Exception {
        ModuleModel model = new GeneratorHelper().generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testmodule.customgroup");
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.customgroup", (Object)model.getFqn());
        Assert.assertEquals((Object)"custom", (Object)model.getName());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.groovy.customgroup", (Object)model.translateFqn("groovy"));
    }

    @Test
    public void testNotPrefixingGroupModuleModel() throws Exception {
        try {
            new GeneratorHelper().generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testmodule.notprefixinggroup");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidGroupModuleModel() throws Exception {
        try {
            new GeneratorHelper().generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testmodule.invalidgroup");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testModuleScopedApiModel() throws Exception {
        ClassModel model = new GeneratorHelper().generateClass(ModuleScopedApi.class, new Class[0]);
        Assert.assertEquals((Object)ModuleScopedApi.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.modulescoped", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"simple", (Object)model.getModule().getName());
        ApiTypeInfo type = (ApiTypeInfo)model.getType();
        Assert.assertEquals((Object)"io.vertx.test.groovy.codegen.testmodule.modulescoped.ModuleScopedApi", (Object)type.translateName("groovy"));
        Assert.assertEquals((Object)"io.vertx.test.ceylon.simple.ModuleScopedApi", (Object)type.translateName(TypeNameTranslator.composite((String)"ceylon")));
    }

    @Test
    public void testEmptyPkg() throws Exception {
        ClassModel model = new GeneratorHelper().generateClass(EmptyPkg.class, new Class[0]);
        Assert.assertEquals((Object)EmptyPkg.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.emptypkg", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"simple", (Object)model.getModule().getName());
        ApiTypeInfo type = (ApiTypeInfo)model.getType();
        Assert.assertEquals((Object)"io.vertx.test.groovy.codegen.testmodule.emptypkg.empty.sub.EmptyPkg", (Object)type.translateName("groovy"));
        Assert.assertEquals((Object)"io.vertx.test.ceylon.simple.empty.sub.EmptyPkg", (Object)type.translateName(TypeNameTranslator.composite((String)"ceylon")));
    }

    @Test
    public void testModuleScopedSubApiModel() throws Exception {
        ClassModel model = new GeneratorHelper().generateClass(ModuleScopedSubApi.class, new Class[0]);
        Assert.assertEquals((Object)ModuleScopedSubApi.class.getName(), (Object)model.getFqn());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.modulescoped", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"simple", (Object)model.getModule().getName());
        ApiTypeInfo type = (ApiTypeInfo)model.getType();
        Assert.assertEquals((Object)"io.vertx.test.groovy.codegen.testmodule.modulescoped.sub.ModuleScopedSubApi", (Object)type.translateName("groovy"));
        Assert.assertEquals((Object)"io.vertx.test.ceylon.simple.sub.ModuleScopedSubApi", (Object)type.translateName(TypeNameTranslator.composite((String)"ceylon")));
    }

    @Test
    public void testModuleScopedDataObjectModel() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ModuleScopedDataObject.class, new Class[0]);
        Assert.assertEquals((Object)ModuleScopedDataObject.class.getName(), (Object)model.getFqn());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.modulescoped", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"simple", (Object)model.getModule().getName());
    }

    @Test
    public void testModuleScopedSubDataObjectModel() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ModuleScopedSubDataObject.class, new Class[0]);
        Assert.assertEquals((Object)ModuleScopedSubDataObject.class.getName(), (Object)model.getFqn());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.modulescoped", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"simple", (Object)model.getModule().getName());
    }

    @Test
    public void testVertxCoreModuleScopedApiModel() throws Exception {
        ClassModel model = new GeneratorHelper().generateClass(VertxCoreModuleScopedApi.class, new Class[0]);
        Assert.assertEquals((Object)VertxCoreModuleScopedApi.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.vertx.core", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"vertx", (Object)model.getModule().getName());
        ApiTypeInfo type = (ApiTypeInfo)model.getType();
        Assert.assertEquals((Object)"io.vertx.groovy.test.codegen.testmodule.vertx.core.VertxCoreModuleScopedApi", (Object)type.translateName("groovy"));
        Assert.assertEquals((Object)"io.vertx.ceylon.core.VertxCoreModuleScopedApi", (Object)type.translateName(TypeNameTranslator.composite((String)"ceylon")));
    }

    @Test
    public void testVertxOtherModuleScopedApiModel() throws Exception {
        ClassModel model = new GeneratorHelper().generateClass(VertxOtherModuleScopedApi.class, new Class[0]);
        Assert.assertEquals((Object)VertxOtherModuleScopedApi.class.getName(), (Object)model.getIfaceFQCN());
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.vertx.other", (Object)model.getModule().getPackageName());
        Assert.assertEquals((Object)"vertx-other", (Object)model.getModule().getName());
        ApiTypeInfo type = (ApiTypeInfo)model.getType();
        Assert.assertEquals((Object)"io.vertx.groovy.test.codegen.testmodule.vertx.other.VertxOtherModuleScopedApi", (Object)type.translateName("groovy"));
        Assert.assertEquals((Object)"io.vertx.ceylon.other.VertxOtherModuleScopedApi", (Object)type.translateName(TypeNameTranslator.composite((String)"ceylon")));
    }

    @Test
    public void testNoModuleApiModel() throws Exception {
        try {
            new GeneratorHelper().generateClass(NoModuleApi.class, new Class[0]);
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testNoModuleDataObjectModel() throws Exception {
        try {
            new GeneratorHelper().generateDataObject(NoModuleDataObject.class, new Class[0]);
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testVertxModuleWithUnderscorePkg() throws Exception {
        ModuleModel model = new GeneratorHelper().generateModule(TestApi.class.getClassLoader(), "io.vertx.test.codegen.test_module_with_underscore_pkg");
    }
}

