/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.test.codegen.ClassTestBase;
import io.vertx.test.codegen.GeneratorHelper;
import io.vertx.test.codegen.ModuleTest;
import io.vertx.test.codegen.testjsonmapper.methodmapper.APIInterfaceWithZonedDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JsonMapperTest
extends ClassTestBase {
    @Test
    public void testJsonMapperMustFailMethodOverloadCheck() throws Exception {
        try {
            new GeneratorHelper().generateClass(io.vertx.test.codegen.testjsonmapper.ambiguousoverload.APIInterfaceWithZonedDateTime.class, new Class[0]);
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonMapperMustHaveValidJsonType() throws Exception {
        try {
            new GeneratorHelper().registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.illegaljsontype.APIInterfaceWithZonedDateTime.class.getName(), "serialize").registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.illegaljsontype.APIInterfaceWithZonedDateTime.class.getName(), "deserialize").generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testjsonmapper.illegaljsontype");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testMethodMapperMustBeStatic() throws Exception {
        try {
            new GeneratorHelper().registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.nonstaticmethodmapper.APIInterfaceWithZonedDateTime.class.getName(), "serialize").generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testjsonmapper.nonstaticmethodmapper");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testMethodMapperMustBePublic() throws Exception {
        try {
            new GeneratorHelper().registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.nonpublicmethodmapper.APIInterfaceWithZonedDateTime.class.getName(), "serialize").generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testjsonmapper.nonpublicmethodmapper");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testNoArgsMethodMapper() throws Exception {
        try {
            new GeneratorHelper().registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.noargsmethodmapper.APIInterfaceWithZonedDateTime.class.getName(), "deserialize").generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testjsonmapper.noargsmethodmapper");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testTooManyArgsMethodMapper() throws Exception {
        try {
            new GeneratorHelper().registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.toomanyargsmethodmapper.APIInterfaceWithZonedDateTime.class.getName(), "deserialize").generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testjsonmapper.toomanyargsmethodmapper");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonMapperInvalidMethodReturnType() throws Exception {
        try {
            new GeneratorHelper().registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.invalidmethodreturntype.APIInterfaceWithZonedDateTime.class.getName(), "deserialize").generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testjsonmapper.invalidmethodreturntype");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonMapperInvalidMethodParamType() throws Exception {
        try {
            new GeneratorHelper().registerConverter(ZonedDateTime.class, io.vertx.test.codegen.testjsonmapper.invalidmethodparamtype.APIInterfaceWithZonedDateTime.class.getName(), "serialize").generateModule(ModuleTest.class.getClassLoader(), "io.vertx.test.codegen.testjsonmapper.invalidmethodparamtype");
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testMethodMapper() throws Exception {
        ClassModel model = new GeneratorHelper().registerConverter(ZonedDateTime.class, APIInterfaceWithZonedDateTime.class.getName(), "serialize").registerConverter(ZonedDateTime.class, APIInterfaceWithZonedDateTime.class.getName(), "deserialize").generateClass(APIInterfaceWithZonedDateTime.class, new Class[0]);
        this.testMapper(model);
    }

    private void testMapper(ClassModel model) throws Exception {
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
        MethodInfo method1 = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method1, "doSomething", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params = method1.getParams();
        Assert.assertNotNull((Object)((ParamInfo)params.get(0)).getType().getDataObject());
        Assert.assertEquals((Object)ZonedDateTime.class.getName(), (Object)((ParamInfo)params.get(0)).getType().getName());
        MethodInfo method2 = (MethodInfo)model.getMethods().get(1);
        this.checkMethod(method2, "returnSomething", 0, "java.time.ZonedDateTime", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        Assert.assertNotNull((Object)method2.getReturnType().getDataObject());
    }

    @Test
    public void testValidMethodOverload() throws Exception {
        ClassModel model = new GeneratorHelper().registerConverter(ZonedDateTime.class, APIInterfaceWithZonedDateTime.class.getName(), "deserialize").generateClass(io.vertx.test.codegen.testjsonmapper.interfacewithoverloads.APIInterfaceWithZonedDateTime.class, new Class[0]);
        Assert.assertTrue((boolean)model.getSuperTypes().isEmpty());
        Assert.assertEquals((long)2L, (long)model.getMethods().size());
        MethodInfo method1 = (MethodInfo)model.getMethods().get(0);
        this.checkMethod(method1, "doSomething", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params1 = method1.getParams();
        Assert.assertNotNull((Object)((ParamInfo)params1.get(0)).getType().getDataObject());
        Assert.assertEquals((Object)ZonedDateTime.class.getName(), (Object)((ParamInfo)params1.get(0)).getType().getName());
        MethodInfo method2 = (MethodInfo)model.getMethods().get(1);
        this.checkMethod(method2, "doSomething", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        List params2 = method2.getParams();
        Assert.assertTrue((boolean)(((ParamInfo)params2.get(0)).getType() instanceof PrimitiveTypeInfo));
        Assert.assertEquals((Object)Long.TYPE.getName(), (Object)((ParamInfo)params2.get(0)).getType().getName());
    }
}

