/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.format.CamelCase;
import io.vertx.codegen.format.Case;
import io.vertx.codegen.format.KebabCase;
import io.vertx.codegen.format.LowerCamelCase;
import io.vertx.codegen.format.QualifiedCase;
import io.vertx.codegen.format.SnakeCase;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class CaseTest {
    @Test
    public void testFormatCamelCase() {
        this.formatCamelCase("", "");
        this.formatCamelCase("Foo", "foo");
        this.formatCamelCase("Foo", "Foo");
        this.formatCamelCase("FOO", "FOO");
        this.formatCamelCase("FooBar", "Foo", "Bar");
        this.formatCamelCase("FooBar", "Foo", "bar");
        this.formatCamelCase("FooBar", "Foo", "", "Bar");
        this.formatCamelCase("FOOBar", "FOO", "", "Bar");
    }

    @Test
    public void testParseCamelCase() {
        this.parseCamelCase("", new String[0]);
        this.parseCamelCase("Foo", "Foo");
        this.parseCamelCase("FooBar", "Foo", "Bar");
        this.parseCamelCase("FooBarJuu", "Foo", "Bar", "Juu");
        this.parseCamelCase("URL", "URL");
        this.parseCamelCase("URLDecoder", "URL", "Decoder");
        this.parseCamelCase("testSomething", "test", "Something");
        this.parseCamelCase("testURL", "test", "URL");
        this.parseCamelCase("test123", "test123");
    }

    @Test
    public void testFormatLowerCamelCase() {
        this.formatLowerCamelCase("", "");
        this.formatLowerCamelCase("foo", "foo");
        this.formatLowerCamelCase("foo", "Foo");
        this.formatLowerCamelCase("foo", "FOO");
        this.formatLowerCamelCase("fooBar", "Foo", "Bar");
        this.formatLowerCamelCase("fooBar", "Foo", "bar");
        this.formatLowerCamelCase("fooBar", "Foo", "", "Bar");
        this.formatLowerCamelCase("fooBar", "FOO", "", "Bar");
        this.formatLowerCamelCase("fooBarJuu", "Foo", "Bar", "Juu");
    }

    @Test
    public void testFormatQualifiedCase() {
        this.formatQualifiedCase("", "");
        this.formatQualifiedCase("foo", "foo");
        this.formatQualifiedCase("Foo", "Foo");
        this.formatQualifiedCase("foo.bar", "foo", "bar");
        this.formatQualifiedCase("foo.Bar", "foo", "Bar");
        this.formatQualifiedCase("foo.bar", "foo", "", "bar");
    }

    @Test
    public void testParseQualifiedCase() {
        this.parseQualifiedCase("", new String[0]);
        this.parseQualifiedCase("foo", "foo");
        this.parseQualifiedCase("foo.bar", "foo", "bar");
        this.parseQualifiedCase("foo.bar.juu", "foo", "bar", "juu");
        for (String test : Arrays.asList(".", ".foo", "foo.", "foo..bar")) {
            try {
                QualifiedCase.INSTANCE.parse(test);
                Assert.fail((String)("Was expecting " + test + " to be rejected"));
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testFormatKebabCase() {
        this.formatKebabCase("", "");
        this.formatKebabCase("foo", "foo");
        this.formatKebabCase("foo", "Foo");
        this.formatKebabCase("foo-bar", "Foo", "Bar");
        this.formatKebabCase("foo-bar", "Foo", "bar");
        this.formatKebabCase("foo-bar", "Foo", "", "Bar");
    }

    @Test
    public void testParseKebabCase() {
        this.parseKebabCase("", new String[0]);
        this.parseKebabCase("foo", "foo");
        this.parseKebabCase("foo-bar", "foo", "bar");
        this.parseKebabCase("foo-bar-juu", "foo", "bar", "juu");
        for (String test : Arrays.asList("-", "-foo", "foo-", "foo--bar")) {
            try {
                KebabCase.INSTANCE.parse(test);
                Assert.fail((String)("Was expecting " + test + " to be rejected"));
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testFormatSnakeCase() {
        this.formatSnakeCase("", "");
        this.formatSnakeCase("foo", "foo");
        this.formatSnakeCase("foo", "Foo");
        this.formatSnakeCase("foo_bar", "Foo", "Bar");
        this.formatSnakeCase("foo_bar", "Foo", "bar");
        this.formatSnakeCase("foo_bar", "Foo", "", "Bar");
    }

    @Test
    public void testParseSnakeCase() {
        this.parseSnakeCase("", new String[0]);
        this.parseSnakeCase("foo", "foo");
        this.parseSnakeCase("foo_bar", "foo", "bar");
        this.parseSnakeCase("foo_bar_juu", "foo", "bar", "juu");
        for (String test : Arrays.asList("_", "_foo", "foo_", "foo__bar")) {
            try {
                SnakeCase.INSTANCE.parse(test);
                Assert.fail((String)("Was expecting " + test + " to be rejected"));
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testConversion() {
        Assert.assertEquals((Object)"foo-bar-juu", (Object)CamelCase.INSTANCE.to(KebabCase.INSTANCE, "FooBarJuu"));
        Assert.assertEquals((Object)"foo_bar_juu", (Object)CamelCase.INSTANCE.to(SnakeCase.INSTANCE, "FooBarJuu"));
        Assert.assertEquals((Object)"FooBarJuu", (Object)SnakeCase.INSTANCE.to(CamelCase.INSTANCE, "foo_bar_juu"));
        Assert.assertEquals((Object)"FooBarJuu", (Object)KebabCase.INSTANCE.to(CamelCase.INSTANCE, "foo-bar-juu"));
    }

    private void formatCamelCase(String expected, String ... atoms) {
        this.assertCase(CamelCase.INSTANCE, expected, atoms);
    }

    private void formatLowerCamelCase(String expected, String ... atoms) {
        this.assertCase(LowerCamelCase.INSTANCE, expected, atoms);
    }

    private void formatQualifiedCase(String expected, String ... atoms) {
        this.assertCase(QualifiedCase.INSTANCE, expected, atoms);
    }

    private void formatSnakeCase(String expected, String ... atoms) {
        this.assertCase(SnakeCase.INSTANCE, expected, atoms);
    }

    private void formatKebabCase(String expected, String ... atoms) {
        this.assertCase(KebabCase.INSTANCE, expected, atoms);
    }

    private void parseSnakeCase(String s, String ... expected) {
        this.parseCase(SnakeCase.INSTANCE, s, expected);
    }

    private void parseCamelCase(String s, String ... expected) {
        this.parseCase(CamelCase.INSTANCE, s, expected);
    }

    private void parseQualifiedCase(String s, String ... expected) {
        this.parseCase(QualifiedCase.INSTANCE, s, expected);
    }

    private void parseKebabCase(String s, String ... expected) {
        this.parseCase(KebabCase.INSTANCE, s, expected);
    }

    private void assertCase(Case _case, String expected, String ... atoms) {
        Assert.assertEquals((Object)expected, (Object)_case.format(Arrays.asList(atoms)));
    }

    private void parseCase(Case _case, String s, String ... expected) {
        Assert.assertEquals(Arrays.asList(expected), (Object)_case.parse(s));
    }
}

