/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.DataObjectWithValues;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Map;

public class DataObjectWithValuesConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, DataObjectWithValues obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "booleanValue": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBooleanValue((Boolean)member.getValue());
                    break;
                }
                case "boxedBooleanValue": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBoxedBooleanValue((Boolean)member.getValue());
                    break;
                }
                case "boxedDoubleValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedDoubleValue(((Number)member.getValue()).doubleValue());
                    break;
                }
                case "boxedFloatValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedFloatValue(Float.valueOf(((Number)member.getValue()).floatValue()));
                    break;
                }
                case "boxedIntValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedIntValue(((Number)member.getValue()).intValue());
                    break;
                }
                case "boxedLongValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedLongValue(((Number)member.getValue()).longValue());
                    break;
                }
                case "boxedShortValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedShortValue(((Number)member.getValue()).shortValue());
                    break;
                }
                case "dataObjectValue": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setDataObjectValue(new TestDataObject((JsonObject)member.getValue()));
                    break;
                }
                case "doubleValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDoubleValue(((Number)member.getValue()).doubleValue());
                    break;
                }
                case "enumValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEnumValue(TestEnum.valueOf((String)member.getValue()));
                    break;
                }
                case "floatValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setFloatValue(((Number)member.getValue()).floatValue());
                    break;
                }
                case "genEnumValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGenEnumValue(TestGenEnum.valueOf((String)member.getValue()));
                    break;
                }
                case "instantValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setInstantValue(Instant.from(DateTimeFormatter.ISO_INSTANT.parse((String)member.getValue())));
                    break;
                }
                case "intValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIntValue(((Number)member.getValue()).intValue());
                    break;
                }
                case "jsonArrayValue": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    obj.setJsonArrayValue(((JsonArray)member.getValue()).copy());
                    break;
                }
                case "jsonObjectValue": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJsonObjectValue(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "longValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLongValue(((Number)member.getValue()).longValue());
                    break;
                }
                case "shortValue": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setShortValue(((Number)member.getValue()).shortValue());
                    break;
                }
                case "stringValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStringValue((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(DataObjectWithValues obj, JsonObject json) {
        DataObjectWithValuesConverter.toJson(obj, json.getMap());
    }

    public static void toJson(DataObjectWithValues obj, Map<String, Object> json) {
    }
}

