/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.impl;

import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.OtpKeyGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class OtpKeyGeneratorImpl
implements OtpKeyGenerator {
    public static final int DEFAULT_KEY_SIZE = 160;
    public static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA1";
    private final KeyGenerator keyGenerator;

    public OtpKeyGeneratorImpl() {
        this(DEFAULT_HMAC_ALGORITHM);
    }

    public OtpKeyGeneratorImpl(String algorithm) {
        try {
            switch (algorithm) {
                case "HmacSHA1": 
                case "HmacSHA256": 
                case "HmacSHA512": {
                    this.keyGenerator = KeyGenerator.getInstance(algorithm);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid algorithm, must be HmacSHA{1,256,512}");
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OtpKey generate() {
        return this.generate(160);
    }

    @Override
    public OtpKey generate(int keySize) {
        this.keyGenerator.init(keySize);
        SecretKey key = this.keyGenerator.generateKey();
        return new OtpKey().setKey(Codec.base32Encode((byte[])key.getEncoded())).setAlgorithm(key.getAlgorithm().substring(4));
    }

    @Override
    public String getAlgorithm() {
        return this.keyGenerator.getAlgorithm();
    }
}

