/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.resources;

import glide.api.logging.Logger;
import glide.connectors.resources.EpollResource;
import glide.connectors.resources.KQueuePoolResource;
import glide.connectors.resources.ThreadPoolResource;
import glide.io.netty.channel.epoll.Epoll;
import glide.io.netty.channel.kqueue.KQueue;
import java.util.function.Supplier;
import lombok.Generated;

public final class Platform {
    private static String debugInfo = "Detailed report of checking platform capabilities\n";
    private static final Capabilities capabilities = new Capabilities(Platform.isKQueueAvailable(), Platform.isEPollAvailable(), false, false);

    private static boolean isKQueueAvailable() {
        try {
            debugInfo = debugInfo + "Checking KQUEUE...\n";
            Class.forName("glide.io.netty.channel.kqueue.KQueue");
            debugInfo = debugInfo + "KQUEUE class found\n";
            boolean res = KQueue.isAvailable();
            debugInfo = debugInfo + "KQUEUE is" + (res ? " " : " not") + " available\n";
            if (!res) {
                debugInfo = debugInfo + "Reason: " + String.valueOf(KQueue.unavailabilityCause()) + "\n";
            }
            return res;
        }
        catch (ClassNotFoundException e) {
            debugInfo = debugInfo + "Exception checking KQUEUE:\n" + String.valueOf(e) + "\n";
            return false;
        }
    }

    private static boolean isEPollAvailable() {
        try {
            debugInfo = debugInfo + "Checking EPOLL...\n";
            Class.forName("glide.io.netty.channel.epoll.Epoll");
            debugInfo = debugInfo + "EPOLL class found\n";
            boolean res = Epoll.isAvailable();
            debugInfo = debugInfo + "EPOLL is" + (res ? " " : " not") + " available\n";
            if (!res) {
                debugInfo = debugInfo + "Reason: " + String.valueOf(Epoll.unavailabilityCause()) + "\n";
            }
            return res;
        }
        catch (ClassNotFoundException e) {
            debugInfo = debugInfo + "Exception checking EPOLL\n" + String.valueOf(e) + "\n";
            return false;
        }
    }

    public static Supplier<ThreadPoolResource> getThreadPoolResourceSupplier() {
        if (capabilities.isKQueueAvailable()) {
            return KQueuePoolResource::new;
        }
        if (capabilities.isEPollAvailable()) {
            return EpollResource::new;
        }
        String errorMessage = String.format("Cannot load Netty native components for the current os version and arch: %s %s %s.\n", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        throw new RuntimeException(errorMessage + (Logger.getLoggerLevel() == Logger.Level.DEBUG ? debugInfo : ""));
    }

    @Generated
    private Platform() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Capabilities getCapabilities() {
        return capabilities;
    }

    public static class Capabilities {
        private final boolean isKQueueAvailable;
        private final boolean isEPollAvailable;
        private final boolean isIOUringAvailable;
        private final boolean isNIOAvailable;

        @Generated
        public boolean isKQueueAvailable() {
            return this.isKQueueAvailable;
        }

        @Generated
        public boolean isEPollAvailable() {
            return this.isEPollAvailable;
        }

        @Generated
        public boolean isIOUringAvailable() {
            return this.isIOUringAvailable;
        }

        @Generated
        public boolean isNIOAvailable() {
            return this.isNIOAvailable;
        }

        @Generated
        private Capabilities(boolean isKQueueAvailable, boolean isEPollAvailable, boolean isIOUringAvailable, boolean isNIOAvailable) {
            this.isKQueueAvailable = isKQueueAvailable;
            this.isEPollAvailable = isEPollAvailable;
            this.isIOUringAvailable = isIOUringAvailable;
            this.isNIOAvailable = isNIOAvailable;
        }

        @Generated
        public String toString() {
            return "Platform.Capabilities(isKQueueAvailable=" + this.isKQueueAvailable() + ", isEPollAvailable=" + this.isEPollAvailable() + ", isIOUringAvailable=" + this.isIOUringAvailable() + ", isNIOAvailable=" + this.isNIOAvailable() + ")";
        }
    }
}

