/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import glide.api.models.GlideString;
import glide.api.models.PubSubMessage;
import glide.api.models.exceptions.ConfigurationError;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import lombok.Generated;

public abstract class BaseSubscriptionConfiguration {
    protected final Optional<MessageCallback> callback;
    protected final Optional<Object> context;

    @Generated
    public Optional<MessageCallback> getCallback() {
        return this.callback;
    }

    @Generated
    public Optional<Object> getContext() {
        return this.context;
    }

    @Generated
    public BaseSubscriptionConfiguration(Optional<MessageCallback> callback, Optional<Object> context) {
        this.callback = callback;
        this.context = context;
    }

    public static abstract class BaseSubscriptionConfigurationBuilder<B extends BaseSubscriptionConfigurationBuilder<B, C>, C extends BaseSubscriptionConfiguration> {
        protected Optional<MessageCallback> callback = Optional.empty();
        protected Optional<Object> context = Optional.empty();

        protected <M extends ChannelMode> void addSubscription(Map<M, Set<GlideString>> subscriptions, M mode, GlideString channelOrPattern) {
            if (!subscriptions.containsKey(mode)) {
                subscriptions.put(mode, new LinkedHashSet());
            }
            subscriptions.get(mode).add(channelOrPattern);
        }

        protected abstract B self();

        protected abstract C build();

        public B callback(MessageCallback callback, Object context) {
            if (context != null && callback == null) {
                throw new ConfigurationError("PubSub subscriptions with a context require a callback function to be configured.");
            }
            this.callback = Optional.ofNullable(callback);
            this.context = Optional.ofNullable(context);
            return this.self();
        }

        public B callback(MessageCallback callback) {
            if (callback == null && this.context.isPresent()) {
                throw new ConfigurationError("PubSub subscriptions with a context require a callback function to be configured.");
            }
            this.callback = Optional.ofNullable(callback);
            return this.self();
        }
    }

    public static interface MessageCallback
    extends BiConsumer<PubSubMessage, Object> {
    }

    public static interface ChannelMode {
    }
}

