/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.geospatial;

import glide.api.models.commands.geospatial.GeoUnit;

public final class GeoSearchShape {
    private final SearchShape shape;
    private final double radius;
    private final double width;
    private final double height;
    private final GeoUnit unit;

    public GeoSearchShape(double radius, GeoUnit unit) {
        this.shape = SearchShape.BYRADIUS;
        this.radius = radius;
        this.unit = unit;
        this.width = -1.0;
        this.height = -1.0;
    }

    public GeoSearchShape(double width, double height, GeoUnit unit) {
        this.shape = SearchShape.BYBOX;
        this.width = width;
        this.height = height;
        this.unit = unit;
        this.radius = -1.0;
    }

    public String[] toArgs() {
        switch (this.shape) {
            case BYRADIUS: {
                return new String[]{this.shape.toString(), Double.toString(this.radius), this.unit.getValkeyAPI()};
            }
            case BYBOX: {
                return new String[]{this.shape.toString(), Double.toString(this.width), Double.toString(this.height), this.unit.getValkeyAPI()};
            }
        }
        return new String[0];
    }

    static enum SearchShape {
        BYRADIUS,
        BYBOX;

    }
}

