/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.commands.SortBaseOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class SortOptions
extends SortBaseOptions {
    public static final String BY_COMMAND_STRING = "BY";
    public static final String GET_COMMAND_STRING = "GET";
    private final String byPattern;
    private final List<String> getPatterns;

    @Override
    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>(List.of(super.toArgs()));
        if (this.byPattern != null) {
            optionArgs.addAll(List.of(BY_COMMAND_STRING, this.byPattern));
        }
        if (this.getPatterns != null) {
            this.getPatterns.stream().forEach(getPattern -> optionArgs.addAll(List.of(GET_COMMAND_STRING, getPattern)));
        }
        return optionArgs.toArray(new String[0]);
    }

    @Generated
    protected SortOptions(SortOptionsBuilder<?, ?> b) {
        super(b);
        List<Object> getPatterns;
        this.byPattern = b.byPattern;
        switch (b.getPatterns == null ? 0 : b.getPatterns.size()) {
            case 0: {
                getPatterns = Collections.emptyList();
                break;
            }
            case 1: {
                getPatterns = Collections.singletonList(b.getPatterns.get(0));
                break;
            }
            default: {
                getPatterns = Collections.unmodifiableList(new ArrayList<String>(b.getPatterns));
            }
        }
        this.getPatterns = getPatterns;
    }

    @Generated
    public static SortOptionsBuilder<?, ?> builder() {
        return new SortOptionsBuilderImpl();
    }

    @Generated
    private static final class SortOptionsBuilderImpl
    extends SortOptionsBuilder<SortOptions, SortOptionsBuilderImpl> {
        @Generated
        private SortOptionsBuilderImpl() {
        }

        @Override
        @Generated
        protected SortOptionsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SortOptions build() {
            return new SortOptions(this);
        }
    }

    @Generated
    public static abstract class SortOptionsBuilder<C extends SortOptions, B extends SortOptionsBuilder<C, B>>
    extends SortBaseOptions.SortBaseOptionsBuilder<C, B> {
        @Generated
        private String byPattern;
        @Generated
        private ArrayList<String> getPatterns;

        @Generated
        public B byPattern(String byPattern) {
            this.byPattern = byPattern;
            return (B)this.self();
        }

        @Generated
        public B getPattern(String getPattern) {
            if (this.getPatterns == null) {
                this.getPatterns = new ArrayList();
            }
            this.getPatterns.add(getPattern);
            return (B)this.self();
        }

        @Generated
        public B getPatterns(Collection<? extends String> getPatterns) {
            if (getPatterns == null) {
                throw new NullPointerException("getPatterns cannot be null");
            }
            if (this.getPatterns == null) {
                this.getPatterns = new ArrayList();
            }
            this.getPatterns.addAll(getPatterns);
            return (B)this.self();
        }

        @Generated
        public B clearGetPatterns() {
            if (this.getPatterns != null) {
                this.getPatterns.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SortOptions.SortOptionsBuilder(super=" + super.toString() + ", byPattern=" + this.byPattern + ", getPatterns=" + String.valueOf(this.getPatterns) + ")";
        }
    }
}

