/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.FT;

import glide.api.models.GlideString;
import glide.utils.ArrayTransformUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class FTAggregateOptions {
    private final Integer timeout;
    private final boolean loadAll;
    private final GlideString[] loadFields;
    private final List<FTAggregateClause> clauses;
    private final Map<String, GlideString> params;

    public GlideString[] toArgs() {
        ArrayList<GlideString> args = new ArrayList<GlideString>();
        if (this.loadAll) {
            args.add(GlideString.gs("LOAD"));
            args.add(GlideString.gs("*"));
        } else if (this.loadFields != null) {
            args.add(GlideString.gs("LOAD"));
            args.add(GlideString.gs(Integer.toString(this.loadFields.length)));
            args.addAll(List.of(this.loadFields));
        }
        if (this.timeout != null) {
            args.add(GlideString.gs("TIMEOUT"));
            args.add(GlideString.gs(this.timeout.toString()));
        }
        if (!this.params.isEmpty()) {
            args.add(GlideString.gs("PARAMS"));
            args.add(GlideString.gs(Integer.toString(this.params.size() * 2)));
            this.params.forEach((name, value) -> {
                args.add(GlideString.gs(name));
                args.add((GlideString)value);
            });
        }
        if (this.clauses != null) {
            for (FTAggregateClause expression : this.clauses) {
                args.addAll(List.of(expression.toArgs()));
            }
        }
        return (GlideString[])args.toArray(GlideString[]::new);
    }

    @Generated
    private static Map<String, GlideString> $default$params() {
        return new HashMap<String, GlideString>();
    }

    @Generated
    FTAggregateOptions(Integer timeout, boolean loadAll, GlideString[] loadFields, List<FTAggregateClause> clauses, Map<String, GlideString> params) {
        this.timeout = timeout;
        this.loadAll = loadAll;
        this.loadFields = loadFields;
        this.clauses = clauses;
        this.params = params;
    }

    @Generated
    public static FTAggregateOptionsBuilder builder() {
        return new FTAggregateOptionsBuilder();
    }

    public static class Apply
    extends FTAggregateClause {
        private final GlideString expression;
        private final GlideString name;

        public Apply(@NonNull GlideString expression, @NonNull GlideString name) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.expression = expression;
            this.name = name;
        }

        public Apply(@NonNull String expression, @NonNull String name) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.expression = GlideString.gs(expression);
            this.name = GlideString.gs(name);
        }

        @Override
        GlideString[] toArgs() {
            return new GlideString[]{GlideString.gs(ClauseType.APPLY.toString()), this.expression, GlideString.gs("AS"), this.name};
        }
    }

    public static class SortBy
    extends FTAggregateClause {
        private final SortProperty[] properties;
        private final Integer max;

        public SortBy(@NonNull SortProperty[] properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties;
            this.max = null;
        }

        public SortBy(@NonNull SortProperty[] properties, int max) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties;
            this.max = max;
        }

        @Override
        GlideString[] toArgs() {
            GlideString[] glideStringArray;
            GlideString[][] glideStringArrayArray = new GlideString[3][];
            glideStringArrayArray[0] = new GlideString[]{GlideString.gs(ClauseType.SORTBY.toString()), GlideString.gs(Integer.toString(this.properties.length * 2))};
            glideStringArrayArray[1] = (GlideString[])Stream.of(this.properties).map(SortProperty::toArgs).flatMap(Stream::of).toArray(GlideString[]::new);
            if (this.max == null) {
                glideStringArray = new GlideString[]{};
            } else {
                GlideString[] glideStringArray2 = new GlideString[2];
                glideStringArray2[0] = GlideString.gs("MAX");
                glideStringArray = glideStringArray2;
                glideStringArray2[1] = GlideString.gs(this.max.toString());
            }
            glideStringArrayArray[2] = glideStringArray;
            return ArrayTransformUtils.concatenateArrays(glideStringArrayArray);
        }

        public static class SortProperty {
            private final GlideString property;
            private final SortOrder order;

            public SortProperty(@NonNull GlideString property, @NonNull SortOrder order) {
                if (property == null) {
                    throw new NullPointerException("property is marked non-null but is null");
                }
                if (order == null) {
                    throw new NullPointerException("order is marked non-null but is null");
                }
                this.property = property;
                this.order = order;
            }

            public SortProperty(@NonNull String property, @NonNull SortOrder order) {
                if (property == null) {
                    throw new NullPointerException("property is marked non-null but is null");
                }
                if (order == null) {
                    throw new NullPointerException("order is marked non-null but is null");
                }
                this.property = GlideString.gs(property);
                this.order = order;
            }

            GlideString[] toArgs() {
                return new GlideString[]{this.property, GlideString.gs(this.order.toString())};
            }
        }

        public static enum SortOrder {
            ASC,
            DESC;

        }
    }

    public static class GroupBy
    extends FTAggregateClause {
        private final GlideString[] properties;
        private final Reducer[] reducers;

        public GroupBy(@NonNull GlideString[] properties, @NonNull Reducer[] reducers) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            if (reducers == null) {
                throw new NullPointerException("reducers is marked non-null but is null");
            }
            this.properties = properties;
            this.reducers = reducers;
        }

        public GroupBy(@NonNull String[] properties, @NonNull Reducer[] reducers) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            if (reducers == null) {
                throw new NullPointerException("reducers is marked non-null but is null");
            }
            this.properties = ArrayTransformUtils.toGlideStringArray(properties);
            this.reducers = reducers;
        }

        @Override
        GlideString[] toArgs() {
            return ArrayTransformUtils.concatenateArrays({GlideString.gs(ClauseType.GROUPBY.toString()), GlideString.gs(Integer.toString(this.properties.length))}, this.properties, (GlideString[])Stream.of(this.reducers).map(Reducer::toArgs).flatMap(Stream::of).toArray(GlideString[]::new));
        }

        public static class Reducer {
            private final String function;
            private final GlideString[] args;
            private final String name;

            public Reducer(@NonNull String function, @NonNull GlideString[] args, @NonNull String name) {
                if (function == null) {
                    throw new NullPointerException("function is marked non-null but is null");
                }
                if (args == null) {
                    throw new NullPointerException("args is marked non-null but is null");
                }
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.function = function;
                this.args = args;
                this.name = name;
            }

            public Reducer(@NonNull String function, @NonNull GlideString[] args) {
                if (function == null) {
                    throw new NullPointerException("function is marked non-null but is null");
                }
                if (args == null) {
                    throw new NullPointerException("args is marked non-null but is null");
                }
                this.function = function;
                this.args = args;
                this.name = null;
            }

            public Reducer(@NonNull String function, @NonNull String[] args, @NonNull String name) {
                if (function == null) {
                    throw new NullPointerException("function is marked non-null but is null");
                }
                if (args == null) {
                    throw new NullPointerException("args is marked non-null but is null");
                }
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.function = function;
                this.args = ArrayTransformUtils.toGlideStringArray(args);
                this.name = name;
            }

            public Reducer(@NonNull String function, @NonNull String[] args) {
                if (function == null) {
                    throw new NullPointerException("function is marked non-null but is null");
                }
                if (args == null) {
                    throw new NullPointerException("args is marked non-null but is null");
                }
                this.function = function;
                this.args = ArrayTransformUtils.toGlideStringArray(args);
                this.name = null;
            }

            GlideString[] toArgs() {
                GlideString[] glideStringArray;
                GlideString[][] glideStringArrayArray = new GlideString[3][];
                glideStringArrayArray[0] = new GlideString[]{GlideString.gs(ClauseType.REDUCE.toString()), GlideString.gs(this.function), GlideString.gs(Integer.toString(this.args.length))};
                glideStringArrayArray[1] = this.args;
                if (this.name == null) {
                    glideStringArray = new GlideString[]{};
                } else {
                    GlideString[] glideStringArray2 = new GlideString[2];
                    glideStringArray2[0] = GlideString.gs("AS");
                    glideStringArray = glideStringArray2;
                    glideStringArray2[1] = GlideString.gs(this.name);
                }
                glideStringArrayArray[2] = glideStringArray;
                return ArrayTransformUtils.concatenateArrays(glideStringArrayArray);
            }
        }
    }

    public static class Filter
    extends FTAggregateClause {
        private final GlideString expression;

        public Filter(@NonNull GlideString expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = expression;
        }

        public Filter(@NonNull String expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = GlideString.gs(expression);
        }

        @Override
        GlideString[] toArgs() {
            return new GlideString[]{GlideString.gs(ClauseType.FILTER.toString()), this.expression};
        }
    }

    public static class Limit
    extends FTAggregateClause {
        private final int offset;
        private final int count;

        public Limit(int offset, int count) {
            this.offset = offset;
            this.count = count;
        }

        @Override
        GlideString[] toArgs() {
            return new GlideString[]{GlideString.gs(ClauseType.LIMIT.toString()), GlideString.gs(Integer.toString(this.offset)), GlideString.gs(Integer.toString(this.count))};
        }
    }

    static enum ClauseType {
        LIMIT,
        FILTER,
        GROUPBY,
        SORTBY,
        REDUCE,
        APPLY;

    }

    public static abstract class FTAggregateClause {
        abstract GlideString[] toArgs();
    }

    public static class FTAggregateOptionsBuilder {
        @Generated
        private Integer timeout;
        @Generated
        private boolean loadAll;
        @Generated
        private GlideString[] loadFields;
        @Generated
        private List<FTAggregateClause> clauses;
        @Generated
        private boolean params$set;
        @Generated
        private Map<String, GlideString> params$value;

        void loadAll(boolean loadAll) {
        }

        void expressions(List<FTAggregateClause> expressions) {
        }

        public FTAggregateOptionsBuilder loadAll() {
            this.loadAll = true;
            return this;
        }

        public FTAggregateOptionsBuilder loadFields(@NonNull String[] fields) {
            if (fields == null) {
                throw new NullPointerException("fields is marked non-null but is null");
            }
            this.loadFields = ArrayTransformUtils.toGlideStringArray(fields);
            this.loadAll = false;
            return this;
        }

        public FTAggregateOptionsBuilder loadFields(@NonNull GlideString[] fields) {
            if (fields == null) {
                throw new NullPointerException("fields is marked non-null but is null");
            }
            this.loadFields = fields;
            this.loadAll = false;
            return this;
        }

        public FTAggregateOptionsBuilder addClause(@NonNull FTAggregateClause clause) {
            if (clause == null) {
                throw new NullPointerException("clause is marked non-null but is null");
            }
            if (this.clauses == null) {
                this.clauses = new ArrayList<FTAggregateClause>();
            }
            this.clauses.add(clause);
            return this;
        }

        @Generated
        FTAggregateOptionsBuilder() {
        }

        @Generated
        public FTAggregateOptionsBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public FTAggregateOptionsBuilder clauses(List<FTAggregateClause> clauses) {
            this.clauses = clauses;
            return this;
        }

        @Generated
        public FTAggregateOptionsBuilder params(Map<String, GlideString> params) {
            this.params$value = params;
            this.params$set = true;
            return this;
        }

        @Generated
        public FTAggregateOptions build() {
            Map<String, GlideString> params$value = this.params$value;
            if (!this.params$set) {
                params$value = FTAggregateOptions.$default$params();
            }
            return new FTAggregateOptions(this.timeout, this.loadAll, this.loadFields, this.clauses, params$value);
        }

        @Generated
        public String toString() {
            return "FTAggregateOptions.FTAggregateOptionsBuilder(timeout=" + this.timeout + ", loadAll=" + this.loadAll + ", loadFields=" + Arrays.deepToString(this.loadFields) + ", clauses=" + String.valueOf(this.clauses) + ", params$value=" + String.valueOf(this.params$value) + ")";
        }
    }
}

