/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;

public final class ExpirySet {
    private final ExpiryType type;
    private final Long count;

    private ExpirySet(ExpiryType type) {
        this.type = type;
        this.count = null;
    }

    private ExpirySet(ExpiryType type, Long count) {
        this.type = type;
        this.count = count;
    }

    public static ExpirySet KeepExisting() {
        return new ExpirySet(ExpiryType.KEEP_EXISTING);
    }

    public static ExpirySet Seconds(Long seconds) {
        if (seconds == null || seconds <= 0L) {
            throw new IllegalArgumentException("Seconds must be positive");
        }
        return new ExpirySet(ExpiryType.SECONDS, seconds);
    }

    public static ExpirySet Milliseconds(Long milliseconds) {
        if (milliseconds == null || milliseconds <= 0L) {
            throw new IllegalArgumentException("Milliseconds must be positive");
        }
        return new ExpirySet(ExpiryType.MILLISECONDS, milliseconds);
    }

    public static ExpirySet UnixSeconds(Long unixSeconds) {
        if (unixSeconds == null || unixSeconds <= 0L) {
            throw new IllegalArgumentException("Unix seconds must be positive");
        }
        return new ExpirySet(ExpiryType.UNIX_SECONDS, unixSeconds);
    }

    public static ExpirySet UnixMilliseconds(Long unixMilliseconds) {
        if (unixMilliseconds == null || unixMilliseconds <= 0L) {
            throw new IllegalArgumentException("Unix milliseconds must be positive");
        }
        return new ExpirySet(ExpiryType.UNIX_MILLISECONDS, unixMilliseconds);
    }

    public static ExpirySet Persist() {
        return new ExpirySet(ExpiryType.PERSIST);
    }

    public void validateForCommand(String commandName) {
        if (commandName == null) {
            throw new IllegalArgumentException("Command name cannot be null");
        }
        if (this.type == ExpiryType.PERSIST && !"HGETEX".equals(commandName)) {
            throw new IllegalArgumentException("PERSIST option is only supported by HGETEX command, not " + commandName);
        }
        if (this.type == ExpiryType.KEEP_EXISTING && "HGETEX".equals(commandName)) {
            throw new IllegalArgumentException("KEEPTTL option is not supported by HGETEX command, use PERSIST instead");
        }
    }

    public String[] toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.type.valkeyApi);
        if (this.type != ExpiryType.KEEP_EXISTING && this.type != ExpiryType.PERSIST) {
            assert (this.count != null) : "Hash field expiration command received expiry type " + String.valueOf((Object)this.type) + ", but count was not set.";
            args.add(this.count.toString());
        }
        return args.toArray(new String[0]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpirySet expirySet = (ExpirySet)obj;
        return this.type == expirySet.type && Objects.equals(this.count, expirySet.count);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.count});
    }

    public String toString() {
        return "ExpirySet{type=" + String.valueOf((Object)this.type) + ", count=" + this.count + "}";
    }

    protected static enum ExpiryType {
        KEEP_EXISTING("KEEPTTL"),
        PERSIST("PERSIST"),
        SECONDS("EX"),
        MILLISECONDS("PX"),
        UNIX_SECONDS("EXAT"),
        UNIX_MILLISECONDS("PXAT");

        private final String valkeyApi;

        @Generated
        private ExpiryType(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }
}

