/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyStreamSinkChannel;
import io.undertow.protocols.spdy.SpdySynReplyStreamSinkChannel;
import io.undertow.protocols.spdy.SpdySynStreamStreamSinkChannel;
import io.undertow.protocols.spdy.SpdySynStreamStreamSourceChannel;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.ServerConnection;
import io.undertow.server.protocol.spdy.SpdyReceiveListener;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import io.undertow.util.StatusCodes;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceChannelWrappingConduit;
import org.xnio.conduits.StreamSourceConduit;

public class SpdyServerConnection
extends ServerConnection {
    private static final HttpString STATUS = new HttpString(":status");
    private static final HttpString VERSION = new HttpString(":version");
    private final HttpHandler rootHandler;
    private final SpdyChannel channel;
    private final SpdySynStreamStreamSourceChannel requestChannel;
    private final SpdyStreamSinkChannel responseChannel;
    private final ConduitStreamSinkChannel conduitStreamSinkChannel;
    private final ConduitStreamSourceChannel conduitStreamSourceChannel;
    private final StreamSinkConduit originalSinkConduit;
    private final StreamSourceConduit originalSourceConduit;
    private final OptionMap undertowOptions;
    private final int bufferSize;
    private SSLSessionInfo sessionInfo;
    private HttpServerExchange exchange;

    public SpdyServerConnection(HttpHandler rootHandler, SpdyChannel channel, SpdySynStreamStreamSourceChannel requestChannel, OptionMap undertowOptions, int bufferSize) {
        this.rootHandler = rootHandler;
        this.channel = channel;
        this.requestChannel = requestChannel;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.responseChannel = requestChannel.getResponseChannel();
        this.originalSinkConduit = new StreamSinkChannelWrappingConduit((StreamSinkChannel)this.responseChannel);
        this.originalSourceConduit = new StreamSourceChannelWrappingConduit((StreamSourceChannel)requestChannel);
        this.conduitStreamSinkChannel = new ConduitStreamSinkChannel((Configurable)this.responseChannel, this.originalSinkConduit);
        this.conduitStreamSourceChannel = new ConduitStreamSourceChannel((Configurable)requestChannel, this.originalSourceConduit);
    }

    public SpdyServerConnection(HttpHandler rootHandler, SpdyChannel channel, SpdySynStreamStreamSinkChannel responseChannel, OptionMap undertowOptions, int bufferSize) {
        this.rootHandler = rootHandler;
        this.channel = channel;
        this.requestChannel = null;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.responseChannel = responseChannel;
        this.originalSinkConduit = new StreamSinkChannelWrappingConduit((StreamSinkChannel)responseChannel);
        this.originalSourceConduit = new StreamSourceChannelWrappingConduit((StreamSourceChannel)this.requestChannel);
        this.conduitStreamSinkChannel = new ConduitStreamSinkChannel((Configurable)responseChannel, this.originalSinkConduit);
        this.conduitStreamSourceChannel = null;
    }

    void setExchange(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.channel.getBufferPool();
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    @Override
    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        throw UndertowMessages.MESSAGES.outOfBandResponseNotSupported();
    }

    @Override
    public boolean isContinueResponseSupported() {
        return false;
    }

    @Override
    public void terminateRequestChannel(HttpServerExchange exchange) {
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.channel.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends ConnectedChannel> getCloseSetter() {
        return this.channel.getCloseSetter();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.channel.getLocalAddress(type);
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public SSLSessionInfo getSslSessionInfo() {
        return this.sessionInfo;
    }

    @Override
    public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    @Override
    public void addCloseListener(final ServerConnection.CloseListener listener) {
        this.requestChannel.getSpdyChannel().addCloseTask(new ChannelListener<SpdyChannel>(){

            public void handleEvent(SpdyChannel channel) {
                listener.closed(SpdyServerConnection.this);
            }
        });
    }

    @Override
    protected StreamConnection upgradeChannel() {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    protected ConduitStreamSinkChannel getSinkChannel() {
        return this.conduitStreamSinkChannel;
    }

    @Override
    protected ConduitStreamSourceChannel getSourceChannel() {
        return this.conduitStreamSourceChannel;
    }

    @Override
    protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange, StreamSinkConduit conduit) {
        HeaderMap headers = this.responseChannel instanceof SpdySynReplyStreamSinkChannel ? ((SpdySynReplyStreamSinkChannel)this.responseChannel).getHeaders() : ((SpdySynStreamStreamSinkChannel)this.responseChannel).getHeaders();
        DateUtils.addDateHeaderIfRequired(exchange);
        headers.put(STATUS, exchange.getResponseCode() + " " + StatusCodes.getReason(exchange.getResponseCode()));
        headers.put(VERSION, exchange.getProtocol().toString());
        Connectors.flattenCookies(exchange);
        return this.originalSinkConduit;
    }

    @Override
    protected boolean isUpgradeSupported() {
        return false;
    }

    @Override
    protected boolean isConnectSupported() {
        return false;
    }

    @Override
    protected void exchangeComplete(HttpServerExchange exchange) {
    }

    @Override
    protected void setUpgradeListener(HttpUpgradeListener upgradeListener) {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    protected void setConnectListener(HttpUpgradeListener connectListener) {
        throw UndertowMessages.MESSAGES.connectNotSupported();
    }

    @Override
    protected void maxEntitySizeUpdated(HttpServerExchange exchange) {
        this.requestChannel.setMaxStreamSize(exchange.getMaxEntitySize());
    }

    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        this.channel.addToAttachmentList(key, value);
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        return this.channel.removeAttachment(key);
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return this.channel.putAttachment(key, value);
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        return this.channel.getAttachmentList(key);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        return this.channel.getAttachment(key);
    }

    @Override
    public String getTransportProtocol() {
        return "spdy/3.1";
    }

    @Override
    public boolean pushResource(String path, HttpString method, HeaderMap requestHeaders) {
        return this.pushResource(path, method, requestHeaders, this.rootHandler);
    }

    @Override
    public boolean pushResource(String path, HttpString method, HeaderMap requestHeaders, final HttpHandler handler) {
        HeaderMap responseHeaders = new HeaderMap();
        try {
            responseHeaders.put(SpdyReceiveListener.PATH, path.toString());
            responseHeaders.put(SpdyReceiveListener.HOST, this.exchange.getHostAndPort());
            responseHeaders.put(SpdyReceiveListener.SCHEME, this.exchange.getRequestScheme());
            responseHeaders.put(SpdyReceiveListener.METHOD, method.toString());
            SpdySynStreamStreamSinkChannel sink = this.channel.createStream(this.requestChannel.getStreamId(), responseHeaders);
            SpdyServerConnection newConnection = new SpdyServerConnection(this.rootHandler, this.channel, sink, this.getUndertowOptions(), this.getBufferSize());
            final HttpServerExchange exchange = new HttpServerExchange(newConnection, requestHeaders, responseHeaders, this.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, -1L));
            newConnection.setExchange(exchange);
            exchange.setRequestMethod(method);
            exchange.setProtocol(Protocols.HTTP_1_1);
            exchange.setRequestScheme(this.exchange.getRequestScheme());
            Connectors.setExchangeRequestPath(exchange, path, (String)this.getUndertowOptions().get(UndertowOptions.URL_CHARSET, (Object)StandardCharsets.UTF_8.name()), this.getUndertowOptions().get(UndertowOptions.DECODE_URL, true), this.getUndertowOptions().get(UndertowOptions.ALLOW_ENCODED_SLASH, false), new StringBuilder());
            Connectors.terminateRequest(exchange);
            this.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    Connectors.executeRootHandler(handler, exchange);
                }
            });
            return true;
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            return false;
        }
    }

    @Override
    public boolean isPushSupported() {
        return true;
    }
}

