/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.spdy;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.BytesReceivedStreamSourceConduit;
import io.undertow.conduits.BytesSentStreamSinkConduit;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.spdy.SpdyReceiveListener;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class SpdyOpenListener
implements ChannelListener<StreamConnection>,
DelegateOpenListener {
    public static final String SPDY_3_1 = "spdy/3.1";
    private final Pool<ByteBuffer> bufferPool;
    private final Pool<ByteBuffer> heapBufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;
    private final ConnectorStatisticsImpl connectorStatistics;

    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool) {
        this(pool, heapBufferPool, OptionMap.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool, OptionMap undertowOptions) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        Pooled buf = pool.allocate();
        this.bufferSize = ((ByteBuffer)buf.getResource()).remaining();
        buf.free();
        this.heapBufferPool = heapBufferPool;
        Pooled buff = heapBufferPool.allocate();
        try {
            if (!((ByteBuffer)buff.getResource()).hasArray()) {
                throw UndertowMessages.MESSAGES.mustProvideHeapBuffer();
            }
        }
        finally {
            buff.free();
        }
        this.connectorStatistics = new ConnectorStatisticsImpl();
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    public void handleEvent(StreamConnection channel) {
        this.handleEvent(channel, null);
    }

    @Override
    public void handleEvent(StreamConnection channel, Pooled<ByteBuffer> buffer) {
        SpdyChannel spdyChannel = new SpdyChannel(channel, this.bufferPool, buffer, this.heapBufferPool, false);
        Integer idleTimeout = (Integer)this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
        if (idleTimeout != null && idleTimeout > 0) {
            spdyChannel.setIdleTimeout(idleTimeout.intValue());
        }
        if (this.statisticsEnabled) {
            channel.getSinkChannel().setConduit((StreamSinkConduit)new BytesSentStreamSinkConduit(channel.getSinkChannel().getConduit(), this.connectorStatistics.sentAccumulator()));
            channel.getSourceChannel().setConduit((StreamSourceConduit)new BytesReceivedStreamSourceConduit(channel.getSourceChannel().getConduit(), this.connectorStatistics.receivedAccumulator()));
        }
        spdyChannel.getReceiveSetter().set((ChannelListener)new SpdyReceiveListener(this.rootHandler, this.getUndertowOptions(), this.bufferSize, this.connectorStatistics));
        spdyChannel.resumeReceives();
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            return this.connectorStatistics;
        }
        return null;
    }
}

