/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyControlFrameStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;

class SpdyRstStreamSinkChannel
extends SpdyControlFrameStreamSinkChannel {
    private final int streamId;
    private final int statusCode;

    protected SpdyRstStreamSinkChannel(SpdyChannel channel, int streamId, int statusCode) {
        super(channel);
        this.statusCode = statusCode;
        this.streamId = streamId;
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 3;
        SpdyProtocolUtils.putInt(buf, firstInt);
        SpdyProtocolUtils.putInt(buf, 8);
        SpdyProtocolUtils.putInt(buf, this.streamId);
        SpdyProtocolUtils.putInt(buf, this.statusCode);
        buf.flip();
        return new SendFrameHeader(new ImmediatePooled<ByteBuffer>(buf));
    }
}

