/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.DateUtils;
import java.util.Date;

public class DateTimeAttribute
implements ExchangeAttribute {
    public static final String DATE_TIME_SHORT = "%t";
    public static final String DATE_TIME = "%{DATE_TIME}";
    public static final ExchangeAttribute INSTANCE = new DateTimeAttribute();

    private DateTimeAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return DateUtils.toCommonLogFormat(new Date());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Date time", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Date Time";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(DateTimeAttribute.DATE_TIME) || token.equals(DateTimeAttribute.DATE_TIME_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

