/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.stats.DecayCounter;
import io.airlift.stats.DecayTDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;

public class TimeDistribution {
    private static final double[] SNAPSHOT_QUANTILES = new double[]{0.5, 0.75, 0.9, 0.95, 0.99};
    private static final double[] PERCENTILES = new double[100];
    private final double alpha;
    @GuardedBy(value="this")
    private DecayTDigest digest;
    @GuardedBy(value="this")
    private final DecayCounter total;
    private final TimeUnit unit;

    public TimeDistribution() {
        this(TimeUnit.SECONDS);
    }

    public TimeDistribution(TimeUnit unit) {
        this(0.0, unit);
    }

    public TimeDistribution(double alpha) {
        this(alpha, TimeUnit.SECONDS);
    }

    public TimeDistribution(double alpha, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit is null");
        this.alpha = alpha;
        this.digest = new DecayTDigest(100.0, alpha);
        this.total = new DecayCounter(alpha);
        this.unit = unit;
    }

    public synchronized void add(long value) {
        this.digest.add(value);
        this.total.add(value);
    }

    @Managed
    public synchronized double getCount() {
        return this.digest.getCount();
    }

    @Managed
    public synchronized double getP50() {
        return this.convertToUnit(this.digest.valueAt(0.5));
    }

    @Managed
    public synchronized double getP75() {
        return this.convertToUnit(this.digest.valueAt(0.75));
    }

    @Managed
    public synchronized double getP90() {
        return this.convertToUnit(this.digest.valueAt(0.9));
    }

    @Managed
    public synchronized double getP95() {
        return this.convertToUnit(this.digest.valueAt(0.95));
    }

    @Managed
    public synchronized double getP99() {
        return this.convertToUnit(this.digest.valueAt(0.99));
    }

    @Managed
    public synchronized double getMin() {
        return this.convertToUnit(this.digest.getMin());
    }

    @Managed
    public synchronized double getMax() {
        return this.convertToUnit(this.digest.getMax());
    }

    @Managed
    public synchronized double getAvg() {
        return this.convertToUnit(this.total.getCount()) / this.getCount();
    }

    @Managed
    public TimeUnit getUnit() {
        return this.unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public Map<Double, Double> getPercentiles() {
        double[] values;
        TimeDistribution timeDistribution = this;
        synchronized (timeDistribution) {
            values = this.digest.valuesAt(PERCENTILES);
        }
        Verify.verify((values.length == PERCENTILES.length ? 1 : 0) != 0, (String)"values length mismatch", (Object[])new Object[0]);
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.put(PERCENTILES[i], values[i]);
        }
        return result;
    }

    private double convertToUnit(long nanos) {
        if (nanos == Long.MAX_VALUE || nanos == Long.MIN_VALUE) {
            return Double.NaN;
        }
        return (double)nanos * 1.0 / (double)this.unit.toNanos(1L);
    }

    private double convertToUnit(double nanos) {
        return TimeDistribution.convertToUnit(nanos, this.unit.toNanos(1L));
    }

    private static double convertToUnit(double nanos, double unitNanos) {
        return nanos / unitNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeDistributionSnapshot snapshot() {
        double[] quantiles;
        double max;
        double min;
        double digestCount;
        double totalCount;
        TimeDistribution timeDistribution = this;
        synchronized (timeDistribution) {
            totalCount = this.total.getCount();
            digestCount = this.digest.getCount();
            min = this.digest.getMin();
            max = this.digest.getMax();
            quantiles = this.digest.valuesAt(SNAPSHOT_QUANTILES);
        }
        double unitNanos = this.unit.toNanos(1L);
        double average = TimeDistribution.convertToUnit(totalCount, unitNanos) / digestCount;
        return new TimeDistributionSnapshot(digestCount, TimeDistribution.convertToUnit(quantiles[0], unitNanos), TimeDistribution.convertToUnit(quantiles[1], unitNanos), TimeDistribution.convertToUnit(quantiles[2], unitNanos), TimeDistribution.convertToUnit(quantiles[3], unitNanos), TimeDistribution.convertToUnit(quantiles[4], unitNanos), TimeDistribution.convertToUnit(min, unitNanos), TimeDistribution.convertToUnit(max, unitNanos), average, this.unit);
    }

    @Managed
    public synchronized void reset() {
        this.total.reset();
        this.digest = new DecayTDigest(100.0, this.alpha);
    }

    static {
        for (int i = 0; i < 100; ++i) {
            TimeDistribution.PERCENTILES[i] = (double)i / 100.0;
        }
    }

    public static class TimeDistributionSnapshot {
        private final double count;
        private final double p50;
        private final double p75;
        private final double p90;
        private final double p95;
        private final double p99;
        private final double min;
        private final double max;
        private final double avg;
        private final TimeUnit unit;

        @JsonCreator
        public TimeDistributionSnapshot(@JsonProperty(value="count") double count, @JsonProperty(value="p50") double p50, @JsonProperty(value="p75") double p75, @JsonProperty(value="p90") double p90, @JsonProperty(value="p95") double p95, @JsonProperty(value="p99") double p99, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="avg") double avg, @JsonProperty(value="unit") TimeUnit unit) {
            this.count = count;
            this.p50 = p50;
            this.p75 = p75;
            this.p90 = p90;
            this.p95 = p95;
            this.p99 = p99;
            this.min = min;
            this.max = max;
            this.avg = avg;
            this.unit = unit;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public double getP50() {
            return this.p50;
        }

        @JsonProperty
        public double getP75() {
            return this.p75;
        }

        @JsonProperty
        public double getP90() {
            return this.p90;
        }

        @JsonProperty
        public double getP95() {
            return this.p95;
        }

        @JsonProperty
        public double getP99() {
            return this.p99;
        }

        @JsonProperty
        public double getMin() {
            return this.min;
        }

        @JsonProperty
        public double getMax() {
            return this.max;
        }

        @JsonProperty
        public double getAvg() {
            return this.avg;
        }

        @JsonProperty
        public TimeUnit unit() {
            return this.unit;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("p50", this.p50).add("p75", this.p75).add("p90", this.p90).add("p95", this.p95).add("p99", this.p99).add("min", this.min).add("max", this.max).add("avg", this.avg).add("unit", (Object)this.unit).toString();
        }
    }
}

