/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.http.client.GlobalFilter;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpClientModule;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.HttpStatusListener;
import io.airlift.http.client.TraceTokenRequestFilter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;

public class HttpClientBinder {
    private final Binder binder;
    private final Multibinder<HttpRequestFilter> globalFilterBinder;
    private final Multibinder<HttpStatusListener> globalStatusListenerBinder;

    private HttpClientBinder(Binder binder) {
        this.binder = binder.skipSources(new Class[]{this.getClass()});
        this.globalFilterBinder = Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, GlobalFilter.class);
        this.globalStatusListenerBinder = Multibinder.newSetBinder((Binder)binder, HttpStatusListener.class, GlobalFilter.class);
    }

    public static HttpClientBinder httpClientBinder(Binder binder) {
        return new HttpClientBinder(binder);
    }

    public HttpClientBindingBuilder bindHttpClient(String name, Class<? extends Annotation> annotation) {
        HttpClientModule module = new HttpClientModule(name, annotation);
        this.binder.install((Module)module);
        return new HttpClientBindingBuilder(module, (Multibinder<HttpRequestFilter>)Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, annotation), (Multibinder<HttpStatusListener>)Multibinder.newSetBinder((Binder)this.binder, HttpStatusListener.class, annotation));
    }

    public LinkedBindingBuilder<HttpRequestFilter> addGlobalFilterBinding() {
        return this.globalFilterBinder.addBinding();
    }

    public LinkedBindingBuilder<HttpStatusListener> addGlobalStatusListenerBinding() {
        return this.globalStatusListenerBinder.addBinding();
    }

    public HttpClientBinder bindGlobalFilter(Class<? extends HttpRequestFilter> filterClass) {
        this.globalFilterBinder.addBinding().to(filterClass).in(Scopes.SINGLETON);
        return this;
    }

    public HttpClientBinder bindGlobalFilter(HttpRequestFilter filter) {
        this.globalFilterBinder.addBinding().toInstance((Object)filter);
        return this;
    }

    public static class HttpClientBindingBuilder {
        private final HttpClientModule module;
        private final Multibinder<HttpRequestFilter> filterBinder;
        private final Multibinder<HttpStatusListener> statusListenerBinder;

        public HttpClientBindingBuilder(HttpClientModule module, Multibinder<HttpRequestFilter> filterBinder, Multibinder<HttpStatusListener> statusListenerBinder) {
            this.module = Objects.requireNonNull(module, "module is null");
            this.filterBinder = Objects.requireNonNull(filterBinder, "multibinder is null");
            this.statusListenerBinder = Objects.requireNonNull(statusListenerBinder, "statusListenerBinder is null");
        }

        public HttpClientBindingBuilder withAlias(Class<? extends Annotation> alias) {
            this.module.addAlias(alias);
            return this;
        }

        public HttpClientBindingBuilder withAliases(Collection<Class<? extends Annotation>> aliases) {
            for (Class<? extends Annotation> annotation : aliases) {
                this.module.addAlias(annotation);
            }
            return this;
        }

        public HttpClientBindingBuilder withConfigDefaults(ConfigDefaults<HttpClientConfig> configDefaults) {
            this.module.withConfigDefaults(configDefaults);
            return this;
        }

        public LinkedBindingBuilder<HttpRequestFilter> addFilterBinding() {
            return this.filterBinder.addBinding();
        }

        public HttpClientBindingBuilder withFilter(Class<? extends HttpRequestFilter> filterClass) {
            this.filterBinder.addBinding().to(filterClass);
            return this;
        }

        public HttpClientBindingBuilder withTracing() {
            return this.withFilter(TraceTokenRequestFilter.class);
        }

        public LinkedBindingBuilder<HttpStatusListener> addStatusListenerBinding() {
            return this.statusListenerBinder.addBinding();
        }

        public HttpClientBindingBuilder withStatusListener(Class<? extends HttpStatusListener> listenerClass) {
            this.addStatusListenerBinding().to(listenerClass);
            return this;
        }
    }
}

